myApps运行时RESTful API说明文档 V1.0

## 1.  RESTful API 设计规范与约定说明
### 1.1  **路径规则（Endpoint rule）**

路径又称"终点"（endpoint），表示API的具体网址。

在RESTful架构中，每个网址代表一种资源（resource），所以网址中不能有动词，只能有名词，而且所用的名词往往与数据库的表格名对应。一般来说，数据库中的表都是同种记录的"集合"（collection），所以API中的名词也应该使用复数。

举例来说，有一组API分别提供Document、表单、视图的信息，则它的路径应该设计成下面这样。
```
-   https://api.example.com/api/runtime/documents

-   https://api.example.com/api/runtime/forms

-   https://api.example.com/api/runtime/views
```
以上路径规则是面向资源的，对于CRUD操作是非常友好的，但是面向一些“动作”或“行为”等一些不符合CRUD的服务请求（如操作按钮的运行执行前脚本），单纯的面向资源的路径构建规则就会让人困惑了。

这种情况我们可以以“子资源”来对待（资源后面加行为动词），例如:GitHub上，对一个gists加星操作：
```
PUT /gists/:id/star
```
并且取消星操作：
```
DELETE /gists/:id/star
```

举例来说，有一组API分别提供执行操作按钮的执行前、执行后脚本和业务处理行为，则它的路径应该设计成下面这样。
```
-   https://api.example.com/api/runtime/activitys/{id}/excute

-   https://api.example.com/api/runtime/activitys/{id}/beforactionscript

-   https://api.example.com/api/runtime/activitys/{id}/afteractionscript
```

### 1.2  **HTTP动词 (Http method)**

对于资源的具体操作类型，由HTTP动词表示。

常用的HTTP动词有下面五个（括号里是对应的SQL命令）。
```
-   GET（SELECT）：从服务器取出资源（一项或多项）。

-   POST（CREATE）：在服务器新建一个资源。

-   PUT（UPDATE）：在服务器更新资源（客户端提供改变后的完整资源）。

-   PATCH（UPDATE）：在服务器更新资源（客户端提供改变的属性）。

-   DELETE（DELETE）：从服务器删除资源。
```
下面是一些例子。
```
-   GET /api/runtime/documents：获取Document集合

-   POST /api/runtime/documents：新建一个Document

-   GET /api/runtime/documents/{id}：获取由ID指定的Document

-   PUT /api/runtime/documents/{id}：更新由ID指定的Document（客户端提供全部信息，完整更新）

-   PATCH /api/runtime/documents/{id}：更新由ID指定的Document（客户端提供部分信息，局部更新）

-   DELETE /api/runtime/documents/{id}：删除由ID指定的Document
```

### 1.3  **过滤信息（Filtering）**

如果记录数量很多，服务器不可能都将它们返回给用户。API应该提供参数，过滤返回结果。

下面是一些常见的参数。
```
-   ?_page=2&_page_lines=30：指定第几页，以及每页的记录数。

-   ?_sortby=name&_order=asc：指定返回结果按照哪个属性排序，以及排序顺序。

-   ?form_type =1：指定筛选条件。
```
参数的设计允许存在冗余，即允许API路径和URL参数偶尔有重复。比如，
```
GET /api/runtime/documents/{id}/flowhis
```
 与 
```
GET /api/runtime/flowhis?doc_id={id}
```
的含义是相同的。

### 1.4 **状态码（Status codes）**
----------------------

服务器向用户返回的状态码和提示信息，常见的有以下一些（方括号中是该状态码对应的HTTP动词）。

下面是一些常见的状态码。
```
-   200 OK - [GET]：服务器成功返回用户请求的数据，该操作是幂等的（Idempotent）。

-   201 CREATED - [POST/PUT/PATCH]：用户新建或修改数据成功。

-   202 Accepted - [\*]：表示一个请求已经进入后台排队（异步任务）

-   204 NO CONTENT - [DELETE]：用户删除数据成功。

-   400 INVALID REQUEST -
    [POST/PUT/PATCH]：用户发出的请求有错误，服务器没有进行新建或修改数据的操作，该操作是幂等的。

-   401 Unauthorized - [\*]：表示用户没有权限（令牌、用户名、密码错误）。

-   403 Forbidden - [\*] 表示用户得到授权（与401错误相对），但是访问是被禁止的。

-   404 NOT FOUND -
    [\*]：用户发出的请求针对的是不存在的记录，服务器没有进行操作，该操作是幂等的。

-   406 Not Acceptable -
    [GET]：用户请求的格式不可得（比如用户请求JSON格式，但是只有XML格式）。

-   410 Gone -[GET]：用户请求的资源被永久删除，且不会再得到的。

-   422 Unprocesable entity - [POST/PUT/PATCH]
    当创建一个对象时，发生一个验证错误。

-   500 INTERNAL SERVER ERROR -
    [\*]：服务器发生错误，用户将无法判断发出的请求是否成功。
```

### 1.5  **错误处理（Error handling）**

就像html错误页面能够显示错误信息一样，API
也应该能返回可读的错误信息，它应该和一般的资源格式一致。

-   API应该始终返回相应的状态码，以反映服务器或者请求的状态。

-   API的错误码可以分为两部分，400系列和500系列，400系列表明客户端错误：如错误的请求格式等。500系列表示服务器错误。

-   API应该至少将所有的400系列的错误以JSON形式返回。如果可能500系列的错误也应该如此。

-   JSON格式的错误应该包含以下信息：一个有用的错误信息，一个唯一的错误码，以及任何可能的详细错误描述。如下：


```
{
  "errcode" : 40035,
  "errmsg" : "不合法的参数"
}

```

-   对PUT,POST,PATCH的输入的校验也应该返回相应的详细错误信息，例如：


```
{  
          "errcode" : 40035,  
          "errmsg" : "Validation Failed",  
          "errors" : [
            {  
              "errcode" : 1234,  
              "field" : "first_name",  
              "errmsg" : "First name cannot have fancy characters"  
            },  
            {  
               "errcode" : 1234,  
               "field" : "password",  
               "errmsg" : "Password cannot be blank"  
            }  
          ]  
        }

```

### 1.6 **数据结构（Data structure）**

-   在POST,PUT,PATCH上使用JSON作为输入。

-   注意使用JSON传输的时候，要求请求头里面加入：Content-Type：applicatin/json.否则抛出415异常（unsupported
    media type）。

-   服务器返回的数据格式，统一使用JSON作为输出。

>   服务器返回的JSON数据结构统一如下：

```
{
  "errcode" : 0,
  "errmsg" : "some message",
  "data" : {},
  "errors" : []
}

```

>   参数说明：

| 参数    | 必须 | 说明                 |
|---------|------|----------------------|
| errcode | 是   | 状态码/返回码        |
| errmsg  | 是   | 消息                 |
| data    | 是   | 服务端返回的数据对象 |
| errors  | 否   | 详细错误信息         |

### 1.7 **其他**
----

1.  客户端控制服务端是否需要返回数据、且返回哪些数据的约定

2.  Urls命名规则统一使用蛇形命名法（下划线和小写）

## 2.  **文档（Documents）**

### 获取文档

**请求方式：** GET  
**请求地址：**/api/runtime/{applicationId}/documents/{id}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| id            | 是       | 文档主键 |
| applicationId | 是       | 软件id   |

**权限说明：**

无。

**返回结果：**


```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "value",
        "formid": "value",
        "applicationid": "value",
        "stateid": "value",
        "versions": 1,
        "parentid": "value",
        "authorDeptIndex": "value",
        "stateInt": 0,
        "istmp": false,
        "lastmodified": "value",
        "auditdate": "value",
        "created": "value",
        "authorId": "value",
        "initiator": "value",
        "audituser": "value",
        "lastFlowOperation": 80,
        "stateLabelInfo": "value",
        "auditorList": "value",
        "prevAuditNode": "value",
        "prevAuditUser": "value",
        "sign": "value",
        "items": [
            {
                "name": "value",
                "age": 0,
                "date": "2017-6-23"
            }
        ]
    }
}

```

**参数说明：**

| **参数** | **说明**                                               |
|----------|--------------------------------------------------------|
| errcode  | 返回码                                                 |
| errmsg   | 对返回码的文本描述内容                                 |
| data     | 返回的文档对象，数据结构参考[\#2.9](#文档数据结构说明) |


### 创建文档
------------------------------

**请求方式：** POST  
**请求地址：** /api/runtime/{applicationId}/documents/withoutValid

**请求包体：**


```
{
    "id": "value",
    "formid": "value",
    "applicationid": "value",
    "stateid": "value",
    "versions": 0,
    "parentid": "value",
    "sign": "value",
    "items": [
        {
            "文档接口": "321321"
        }
    ]
}

```

**参数说明：**

| **参数**      | **必须** | **说明**                                             |
|---------------|----------|------------------------------------------------------|
| applicationId | 是       | 软件id                                               |
| 请求包体      | 是       | Document对象，数据结构参考[\#2.9](#文档数据结构说明) |

**权限说明：**

无。

**返回结果：**


```
{  
  "errcode" : 0,  
  "errmsg" : "保存成功",
  "data" : {…} 
}

```

如请求失败，服务端返回详细错误信息，错误状态码以及数据结构参考[\#2.8](#文档数据结构说明)-错误说明。

**参数说明：**

| **参数** | **说明**                                                         |
|----------|------------------------------------------------------------------|
| errcode  | 返回码                                                           |
| errmsg   | 状态码对应的信息文本                                             |
| data     | 返回的持久化后的文档对象，数据结构参考[\#2.8](#文档数据结构说明) |

### 创建文档（带校验）
------------------

**请求方式：** POST  
**请求地址：** /api/runtime/{applicationId}/documents

**请求包体：**

```
{
    "id": "value",
    "formid": "value",
    "applicationid": "value",
    "stateid": "value",
    "versions": 0,
    "parentid": "value",
    "sign": "value",
    "items": [
        {
            "name": "demo",
            "age": 18,
            "date": "2017-6-23"
        }
    ]
}

```

**参数说明：**

| **参数**      | **必须** | **说明**                                             |
|---------------|----------|------------------------------------------------------|
| applicationId | 是       | 软件id                                               |
| 请求包体      | 是       | Document对象，数据结构参考[\#2.9](#文档数据结构说明) |

**权限说明：**

无。

**返回结果：**


```
{  
      "errcode" : 0,  
      "errmsg" : "保存成功",
      "data" : {…} 
    }

```

如请求失败，服务端返回详细错误信息，错误状态码以及数据结构参考[\#2.8](#文档数据结构说明)-错误说明。

**参数说明：**

| **参数** | **说明**                                                         |
|----------|------------------------------------------------------------------|
| errcode  | 返回码                                                           |
| errmsg   | 状态码对应的信息文本                                             |
| data     | 返回的持久化后的文档对象，数据结构参考[\#2.8](#文档数据结构说明) |



### 更新文档
----------

**请求方式：** PUT  
**请求地址：** /api/runtime/{applicationId}/documents/{id}/withoutValid

**请求包体：**


```
{
    "id": "value",
    "viewid": "value",
    "formid": "value",
    "applicationid": "value",
    "stateid": "value",
    "versions": 0,
    "parentid": "value",
    "sign": "value",
    "items": [
        {
            "name": "demo",
            "age": 18,
            "date": "2017-6-23"
        }
    ]
}


```

**参数说明：**

| **参数**      | **必须** | **说明**                                             |
|---------------|----------|------------------------------------------------------|
| Id            | 是       | 文档ID                                               |
| applicationId | 是       | 软件id                                               |
| 请求包体      | 是       | Document对象，数据结构参考[\#2.9](#文档数据结构说明) |

**权限说明：**

无。

**返回结果：**

```
{
  "errcode" : 0,
  "errmsg" : "保存成功",
  "data" : {…} 
}

```

如请求失败，服务端返回详细错误信息，错误状态码以及数据结构参考[\#2.8](#文档数据结构说明)-错误说明。

**参数说明：**

| **参数** | **说明**                                                         |
|----------|------------------------------------------------------------------|
| errcode  | 返回码                                                           |
| errmsg   | 状态码对应的信息文本                                             |
| data     | 返回的持久化后的文档对象，数据结构参考[\#2.8](#文档数据结构说明) |



### 更新文档（带校验）
----------

**请求方式：** PUT  
**请求地址：** /api/runtime/{applicationId}/documents/{id}

**请求包体：**

```
{
    "id": "value",
    "formid": "value",
    "applicationid": "value",
    "stateid": "value",
    "versions": 0,
    "parentid": "value",
    "sign": "value",
    "items": [
        {
            "name": "demo",
            "age": 18,
            "date": "2017-6-23"
        }
    ]
}

```

**参数说明：**

| **参数**      | **必须** | **说明**                                             |
|---------------|----------|------------------------------------------------------|
| Id            | 是       | 文档ID                                               |
| applicationId | 是       | 软件id                                               |
| 请求包体      | 是       | Document对象，数据结构参考[\#2.9](#文档数据结构说明) |

**权限说明：**

无。

**返回结果：**


```
    {
      "errcode" : 0,  
      "errmsg" : "保存成功",
      "data" : {…} 
    }

```

如请求失败，服务端返回详细错误信息，错误状态码以及数据结构参考[\#2.8](#文档数据结构说明)-错误说明。

**参数说明：**

| **参数** | **说明**                                                         |
|----------|------------------------------------------------------------------|
| errcode  | 返回码                                                           |
| errmsg   | 状态码对应的信息文本                                             |
| data     | 返回的持久化后的文档对象，数据结构参考[\#2.8](#文档数据结构说明) |



### 局部更新文档
----------

**请求方式：** PATCH  
**请求地址：** /api/runtime/{applicationId}/documents/{id}

**请求包体：**


```
{
    "id": "value",
    "items": [
        {
            "name": "demo"
        }
    ]
}

```

**参数说明：**

| **参数**      | **必须** | **说明**                                                                     |
|---------------|----------|------------------------------------------------------------------------------|
| applicationId | 是       | 软件id                                                                       |
| 请求包体      | 是       | 仅包含需要更新Document属性和字段内容，数据结构参考[\#2.9](#文档数据结构说明) |

**权限说明：**

无。

**返回结果：**


```
    {
      "errcode" : 0,
      "errmsg" : "保存成功",
      "data" : null
    }

```

如请求失败，服务端返回详细错误信息，错误返回码以及数据结构参考[\#2.8](#文档数据结构说明)-错误说明。

**参数说明：**

| **参数** | **说明**                             |
|----------|--------------------------------------|
| errcode  | 返回码                               |
| errmsg   | 对返回码的文本描述内容               |
| data     | Null，局部更新不返回持久化后文档对象 |



### 删除文档
----------

**请求方式：** DELETE  
**请求地址：** /api/runtime/{applicationId}/documents/{id}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| id            | 是       | 文档主键 |
| applicationId | 是       | 软件id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": null
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |
| data     | Null，删除文档，服务端无需返回数据 |



### 获取文档集合
----------

**请求方式：** GET  
**请求地址：** /api/runtime/{applicationId}/documents?parameter=PARAMETER&
\_page=PAGE&_page_lines=PAGE_LINES&_sortCol=SORTBY&_orderby=ORDER&_sortStatus=

**参数说明：**

| **参数**      | **必须** | **说明**                           |
|---------------|----------|------------------------------------|
| applicationId | 是       | 软件id                             |
| parameter     | 否       | 参数名为过滤条件，参数值为过滤内容 |
| \_page        | 否       | 当前页码，参数为空时默认第一页     |
| \_page_lines  | 否       | 每页行数，参数为空时默认最大值     |
| \_orderby     | 否       | 特定排序类型的排序字段             |
| \_sortCol     | 否       | 排序字段名，可为多个字段名。       |
| \_sortStatus  | 否       | 排序类型（升序asc、降序desc）      |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [],
    "page": 1,
    "page_lines": 30,
    "size": 30,
    "row_count": 100
}

```

**参数说明：**

| **参数**   | **说明**                                                     |
|------------|--------------------------------------------------------------|
| errcode    | 返回码                                                       |
| errmsg     | 状态码对应的信息文本                                         |
| data       | 文档对象集合，文档对象数据结构参考[\#2.8](#文档数据结构说明) |
| page       | 当前页码                                                     |
| page_lines | 每页显示行数                                                 |
| size       | 当前数据行数（data集合的大小）                               |
| row_count  | 数据总数                                                     |



### 批量删除文档
----------

**请求方式：** DELETE  
**请求地址：** /api/runtime/{applicationId}/documents

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |

**请求包体：**

```
[
    "ID1",
    "ID2",
    "ID3"
]

```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": null
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |
| data     | Null，删除文档，服务端无需返回数据 |

### 更新缓存中子表数据(子表为网格视图时使用)
----------

**请求方式：** POST  
**请求地址：** /api/runtime/{applicationId}/documents/{id}/childs

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| id | 是       | 主表id   |

**请求包体：**

```
{
    "id": "value",I
    "formId": "value",
    "applicationId": "value",
    "stateId": "value",
    "versions": 0,
    "parentId": "value",
    "sign": "value",
    "items": [
        {
            "name": "demo",
            "age": 18,
            "date": "2017-6-23"
        }
    ]
}

```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": null
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |
| data     | null |

### 删除缓存中子表数据(子表为网格视图时使用)
----------

**请求方式：** DELETE  
**请求地址：** /api/runtime/{applicationId}/documents/{parentId}/childs/{childId}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| parentId | 是       | 主表id   |
| childId | 是       | 子表id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": null
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |
| data     | null |

### 表单控件校验
----------

**请求方式：** POST  
**请求地址：** /api/runtime/{applicationId}/documents/validate

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |

**请求包体：**

```
{
    "applicationId": "HdPeBqYwJyFyjHkhZu3",
    "id": "__dpcBPOMmeeFHNYTTkBm",
    "templateForm": "",
    "formId": "f4NDOEOVMi7vrgWjzz4",
    "sign": "",
    "parentId": "",
    "subDocuments": []
    "items": {
        "备注": ""
    }
}

```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "errcode": 4001,
        "errmsg": "表单校验不通过",
        "errors": [
            {
                "errcode": 40001,
                "field": "备注",
                "errmsg": "'备注'必须填写！"
            }
        ]
    }
}

```

**参数说明：**

| **参数** | **说明**                           |
|----------|------------------------------------|
| errcode  | 返回码                             |
| errmsg   | 状态码对应的信息文本               |
| data     | 校验信息 |


### 文档数据结构说明
----------

**文档对象（Document）数据结构：**


```
{
    "id": "value",
    "formid": "value",
    "applicationid": "value",
    "mappingId": "value",
    "stateid": "value",
    "versions": 1,
    "parentid": "value",
    "authorDeptIndex": "value",
    "stateInt": 0,
    "istmp": false,
    "lastmodified": "value",
    "auditdate": "value",
    "created": "value",
    "authorId": "value",
    "initiator": "value",
    "audituser": "value",
    "lastFlowOperation": 80,
    "stateLabelInfo": "value",
    "auditorList": "value",
    "prevAuditNode": "value",
    "prevAuditUser": "value",
    "sign": "value",
    "items": [
        {
            "name": "value",
            "age": 0,
            "date": "2017-6-23"
        }
    ]
}

```

**参数说明：**

| **参数**          | **数据类型** | **说明**                               |
|-------------------|--------------|----------------------------------------|
| id                | String       | 主键，文档对象的唯一标识               |
| formid            | String       | 动态表单id                             |
| applicationid     | String       | 软件id                                 |
| parentid          | String       | 父文档id                               |
| mappingId         | String       | 映射到物理表（TLK_XXX）对应数据id      |
| stateid           | String       | 流程实例id                             |
| versions          | Integer      | 版本号                                 |
| stateInt          | Integer      | 流程处理状态标识                       |
| istmp             | Boolean      | 是否临时文档（未持久化）               |
| authorId          | String       | 作者id                                 |
| authorDeptIndex   | String       | 作者部门索引                           |
| initiator         | String       | 流程发起人id                           |
| created           | String       | 创建时间                               |
| lastmodified      | String       | 最后修改时间                           |
| lastFlowOperation | Integer      | 最后流程处理类型标识                   |
| sign              | String       | 签名信息                               |
| stateLabelInfo    | Array        | 流程状态                               |
| auditorList       | Array        | 处理人列表                             |
| prevAuditNode     | Array        | 上一步处理节点列表                     |
| prevAuditUser     | Array        | 上一步节点处理人列表                   |
| items             | Object       | 字段信息，键值对形式（字段名：字段值） |

## 3.  **表单（Forms）**
--------------------------------------------

### 获取表单模板（已废弃）

服务器返回包含表单模板、操作、样式库。

**请求方式：** GET  
**请求地址：**/api/runtime/{applicationId}/forms/{formId}/documents/{docId}/template

**路径参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| formId        | 是       | 表单id   |
| docid         | 是       | 文档id   |

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "document": {
            "id": "value",
            "formid": "value",
            "applicationid": "value",
            "mappingId": "value",
            "stateid": "value",
            "versions": 1,
            "parentid": "value",
            "authorDeptIndex": "value",
            "stateInt": 0,
            "istmp": false,
            "lastmodified": "value",
            "auditdate": "value",
            "created": "value",
            "authorId": "value",
            "initiator": "value",
            "audituser": "value",
            "lastFlowOperation": 80,
            "stateLabelInfo": "value",
            "auditorList": "value",
            "prevAuditNode": "value",
            "prevAuditUser": "value",
            "sign": "value",
            "items": [
                {
                    "name": "value",
                    "age": 0,
                    "date": "2017-6-23"
                }
            ]
        },
        "activitys": [
            {
                "id": "11e7-4c27-f0b88789-a441-734aa5158162",
                "name": "保存",
                "type": 4
            },
            {
                "id": "11e7-4c27-f0b88789-a441-734aa5158162",
                "name": "提交",
                "type": 8
            }
        ],
        "style": "value",
        "approvers": [
            [
                {
                    "instanceId": "11e7-5c9e-f9e93dfc-b2d6-b959e8a4d585",
                    "flowName": "测试流程",
                    "flowId": "11e6-5fae-abde2740-b3ac-31493634e7af",
                    "nodes": [
                        {
                            "nodeId": "1470911349645",
                            "stateLabel": "节点二[标签]",
                            "auditors": [
                                {
                                    "id": "11e6-6ab3-19bfcfc3-bcfe-1f3c25384deb",
                                    "name": "happy"
                                }
                            ]
                        }
                    ]
                }
            ]
        ],
        "html": "htmlencode后的字符串",
            " formTemplate": {
                        "template": "<input type=\"hidden\" id=\"dy_refreshObj\" formid=\"11de-a1ce-12978c3f-a188-7710f5ef0f5e\" docid=\"DQGsf7ngOAez51Jvm9u\" userid=\"11e7-7721-76f875ba-bacd-b744ea587d6a\" mapVal=\"申请单号;申请日期;所属部门;职务;加班类型;开始时间;结束时间;总小时数;加班内容;补偿方式;工资倍数;备注\" /><p style='text-align: right;'>&nbsp;</p><p style='text-align: right;'>申请单号：<o-input data-id=\"DQGsf7ngOAez51Jvm"
             }
    }

```



### 获取表单数据（已废弃）
----------

服务器返回包含数据。

**请求方式：** GET  
**请求地址：** /api/runtime/{applicationId}/forms/{formId}/documents/{docId}/data

**路径参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| formId        | 是       | 表单id   |
| docid         | 是       | 文档id   |

**返回结果：**


```
{
        "errcode": 0,
        "errmsg": "ok",
        "data": {
            "补偿方式": {
            "fieldtype": "VALUE_TYPE_VARCHAR",
            "module": "",
            "hiddenValue": "",
            "classname": "cn.myapps.runtime.dynaform.form.ejb.RadioField",
            "discript": "补偿方式(必填)",
            "id": "DQGsf7ngOAez51Jvm9u_补偿方式",
            "formField": "RadioField",
            "displayType": 2,
            "name": "补偿方式",
            "layout": "horizontal",
            "readOnlyShowValOnly": false,
            "value": "",
            "cssClass": "radio-cmd",
            "textType": "text",
            "refreshOnChanged": true,
            "options": [
                {
                    "option": "补休假期",
                    "value": "补休假期",
                    "def": false
                },
                {
                    "option": "支付加班工资",
                    "value": "支付加班工资",
                    "def": false
                }
            ],
            "divId": "11e5-8695-dc466ce2-b072-3b5a9cb7f21b",
            "layoutType": "horizontal"
        },
        "申请日期": {
            "limit": "false",
            "fieldtype": "VALUE_TYPE_DATE",
            "text": "2018-07-05",
            "hiddenValue": "",
            "classname": "cn.myapps.runtime.dynaform.form.ejb.DateField",
            "discript": "",
            "id": "DQGsf7ngOAez51Jvm9u_申请日期",
            "isdatefield": "true",
            "formField": "DateField",
            "displayType": 2,
            "readOnlyShowValOnly": true,
            "name": "申请日期",
            "value": "2018-07-05",
            "dateFormat": "yyyy-MM-dd",
            "cssClass": "Wdate",
            "textType": "readonly",
            "refreshOnChanged": false,
            "divId": "11e3-8a8e-04808f84-b7a0-251e54e1ec3d",
            "layoutType": "horizontal",
            "prev_Name": ""
        }
 }
}

```



### 获取表单信息
----------

服务器返回包含表单模板、操作、样式库。

**请求方式：** GET
**请求地址：** /api/runtime/{applicationId}/forms/{formId}/documents/{docId}

**路径参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| formId        | 是       | 表单id   |
| docid         | 是       | 文档id   |

**返回结果：**


```
{
        "errcode": 0,
        "errmsg": "ok",
        "data": {
            "document": {
                "id": "value",
                "formid": "value",
                "applicationid": "value",
                "mappingId": "value",
                "stateid": "value",
                "versions": 1,
                "parentid": "value",
                "authorDeptIndex": "value",
                "stateInt": 0,
                "istmp": false,
                "lastmodified": "value",
                "auditdate": "value",
                "created": "value",
                "authorId": "value",
                "initiator": "value",
                "audituser": "value",
                "lastFlowOperation": 80,
                "stateLabelInfo": "value",
                "auditorList": "value",
                "prevAuditNode": "value",
                "prevAuditUser": "value",
                "sign": "value",
                "items": [
                    {
                        "name": "value",
                        "age": 0,
                        "date": "2017-6-23"
                    }
                ]
            },
            "activitys": [
                {
                    "id": "11e7-4c27-f0b88789-a441-734aa5158162",
                    "name": "保存",
                    "type": 4
                },
                {
                    "id": "11e7-4c27-f0b88789-a441-734aa5158162",
                    "name": "提交",
                    "type": 8
                }
            ],
            "style": "value",
            "approvers": [
                [
                    {
                        "instanceId": "11e7-5c9e-f9e93dfc-b2d6-b959e8a4d585",
                        "flowName": "测试流程",
                        "flowId": "11e6-5fae-abde2740-b3ac-31493634e7af",
                        "nodes": [
                            {
                                "nodeId": "1470911349645",
                                "stateLabel": "节点二[标签]",
                                "auditors": [
                                    {
                                        "id": "11e6-6ab3-19bfcfc3-bcfe-1f3c25384deb",
                                        "name": "happy"
                                    }
                                ]
                            }
                        ]
                    }
                ]
            ],
            "formTemplate": {"template":""},
			"showWaterMark":false,
			"waterMarkText":"abs",
            "fields": [
                        {
                            "fieldtype": "VALUE_TYPE_VARCHAR",
                            "hiddenValue": "",
                            "borderType": false,
                            "numberPattern": "",
                            "discript": "",
                            "id": "11e7-61ee-2453c635-991c-c72710268258_单行文本_名称",
                            "displayType": 2,
                            "name": "单行文本_名称",
                            "readOnlyShowValOnly": true,
                            "value": "",
                            "cssClass": "input-cmd",
                            "fieldkeyevent": "Tabkey",
                            "textType": "text",
                            "refreshOnChanged": false,
                            "layoutType": "horizontal"
                        }
            ]
        }
    }

```




### 获取打印表单（已废弃）
----------

服务器返回包含表单打印模板。

**请求方式：** GET  
**请求地址：** /api/runtime/{applicationId}/forms/{formId}/documents/{docId}/print

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| formId        | 是       | 表单id   |
| docid         | 是       | 文档id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "style": "value",
        "html": "htmlencode后的字符串"
    }
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回的表单对象，数据结构参考[\#3.3](#获取pdf文件) |




### 判断表单打开权限(脚本)
----------

执行表单是否可打开脚本，返回运算结果（true/false）。

**请求方式：** GET  
**请求地址：** /api/runtime/{applicationId}/forms/{formId}/documents/{docId}/openable

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| formId        | 是       | 表单id   |
| docid         | 是       | 文档id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": true,
}
```

**参数说明：**

| **参数** | **说明**                 |
|----------|--------------------------|
| errcode  | 返回码                   |
| errmsg   | 对返回码的文本描述内容   |
| data     | 返回运算结果，true/false |

### 判断表单打开权限
----------

判断表单是否具有打开权限，返回运算结果（true/false）。

**请求方式：** GET  
**请求地址：** /api/runtime/{applicationId}/forms/{formId}/openable

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| formId        | 是       | 表单id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": true,
}
```

**参数说明：**

| **参数** | **说明**                 |
|----------|--------------------------|
| errcode  | 返回码                   |
| errmsg   | 对返回码的文本描述内容   |
| data     | 返回运算结果，true/false |

### 校验表单控件值的合法性
--------

>   目前主要用于解决视图选择框带值到表单时做控件值校验，如单行文本框带值到用户选择框，需要对用户选择框值进行校验

**请求方式：** POST  
**请求地址：**/api/runtime/{applicationId}/forms/{formid}/documents/{docid}/validateFieldValue

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| formid | 是       | 表单id   |
| docid         | 是       | 文档id   |

**请求包体：**

```
{
    "mapping":[{"asda":"asda123"}],
    "document":{
        "id": "value",
        "formid": "value",
        "applicationid": "value",
        "stateid": "value",
        "versions": 0,
        "parentid": "value",
        …//其他系统字段
        "sign": "value",
        "items": [
            {
                "name": "demo",
                "age": 18,
                "date": "2017-6-23"
            }
        ]
    }
}

```

**参数说明：**

| **参数**               | **必须** | **说明**                    |
|------------------------|----------|-----------------------------|
| mapping | 是       | 视图选择框映射字段    |
| document               | 是       | 文档对象，数据结构参考\#2.8 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "刷新字段"
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 刷新字段的消息     |

### 获取空文档
----------

服务器创建一个空的文档缓存并返回一个临时的文档。

**请求方式：** GET  
**请求地址：** /api/runtime/{applicationId}/forms/{formId}/empty

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| formId        | 是       | 表单id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": document,
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | Document对象           |



----------
刷新表单


>   表单某控件触发全局刷新表单的动作，服务器根据最新的文档状态重新运算开启重计算功能的全部控件的值脚本，返回状态发生变更的控件内容。

**请求方式：** POST  
**请求地址：** /api/runtime/{applicationId}/forms/{formId}/documents/{docId}/refresh

**请求包体：**

```
{
    "actField": "name",
    "tabId": "",
    "document": {}
}

```

**参数说明：**

| **参数**      | **必须** | **说明**                                 |
|---------------|----------|------------------------------------------|
| applicationId | 是       | 软件id                                   |
| formId        | 是       | 表单id                                   |
| docid         | 是       | 文档id                                   |
| actField      | 是       | 触发刷新的控件名称                       |
| tabId         | 否       | 触发刷新的控件所属的页签id（选项卡模式） |
| document      | 是       | 文档对象，数据结构参考\#2.8              |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data":{
        "fieldName1":"encode后的html代码段1",
        "fieldName2":"encode后的html代码段2"
    }
}

```

**参数说明：**

| **参数** | **说明**                   |
|----------|----------------------------|
| errcode  | 返回码                     |
| errmsg   | 对返回码的文本描述内容     |
| data     | 返回状态发生变更的控件内容 |




### 文件上传控件
----------

**请求方式：** POST  
**请求地址：** /api/runtime/upload?applicationId={applicationId}&allowedTypes={allowedTypes}&fieldId={fieldId}&fileSaveMode={fileSaveMode
}&path={path}&actionType={actionType}

**请求包体：**

**参数说明：**

| **参数**      | **必须** | **说明**           |
|---------------|----------|--------------------|
| applicationId | 是       | 软件id             |
| allowedTypes  | 是       | 允许上传的类型     |
| fieldId       | 是       | 表单字段           |
| fileSaveMode  | 是       | 文件保存模式       |
| path          | 否       | 上传文件保存的路径 |
| actionType    | 是       | 类型               |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "fileName": "1223.txt",
            "filePath": "/uploads/item/2017/6665753f-69db-4510-b0b1-69fd5001c24f.txt",
            "fileSize": 213
            "fileType": ".txt"
        }
    ]
}
```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 返回上传文件信息       |

### 文件排序
--------

**请求方式：** POST  
**请求地址：** /api/runtime/files/sort

**请求包体：**

```
{
        "applicationId": "",
        "formId": "",
        "docId": "",
        "itemName": "合同附件",
        "itemValue": "[{\"name\":\"任务 copy.png\",\"path\":\"/uploads/item/2017/66d379b9-88d5-4804-81ce-f766ba82e289.png\"},{\"name\":\"oa copy.png\",\"path\":\"/uploads/item/2017/41a6f08f-e832-4c9c-96ef-1f195b703bcd.png\"}]"
    }

```

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| formId        | 是       | 表单id   |
| docid         | 是       | 文档id   |
| itemName      | 是       | 字段名称 |
| itemValue     | 是       | 上传文件 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [{"name":"任务 copy.png","path":"/uploads/item/2017/66d379b9-88d5-4804-81ce-f766ba82e289.png"},{"name":"oa copy.png","path":"/uploads/item/2017/41a6f08f-e832-4c9c-96ef-1f195b703bcd.png"}]
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 返回排序后上传文件信息 |




### 删除文件
----------

**请求方式：** DELETE  
**请求地址：**/api/runtime/files/delete?applicationId={applicationId}&formId={formId}&docId={docId}&path={path}

**请求包体：**

**参数说明：**

| **参数**      | **必须** | **说明**     |
|---------------|----------|--------------|
| applicationId | 是       | 软件id       |
| formId        | 是       | 表单id       |
| docId         | 是       | 文档id       |
| path          | 是       | 文件保存路径 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "删除成功"
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 返回删除上传文件信息   |

### Word控件-判断是否可编辑
-----------------------

Word控件在服务端有乐观锁机制，当前word文档正在被其他用户编辑时，当前用户不能将word切换到编辑状态中。

**请求方式：** GET  
**请求地址：** /api/runtime/forms/wordfield/edit?wordid={wordid}

**参数说明：**

| **参数** | **必须** | **说明**   |
|----------|----------|------------|
| wordid d | 是       | Word文档id |

**权限说明：**

无。

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
    "state":"true",
    "massage":""
    }
}

```

**参数说明：**

| **参数** | **说明**                         |
|----------|----------------------------------|
| errcode  | 返回码                           |
| errmsg   | 对返回码的文本描述内容           |
| data     | 返回word文档当前编辑人的对象信息 |

### Word控件-退出编辑
-----------------

Word控件的乐观锁机制，当用户把word文档切换到编辑状态，向服务器发送锁定编辑的请求，退出编辑状态。

**请求方式：** PUT  
**请求地址：** /api/runtime/forms/wordfield/exixtEdit?wordid={wordid}

**参数说明：**

| **参数** | **必须** | **说明**   |
|----------|----------|------------|
| wordid   | 是       | Word文档id |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": ""
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | Null                   |

### 视图选择框控件-执行确定回调脚本
-------------------------------

。

**请求方式：** GET  
**请求地址：** /api/runtime/{applicationId}/forms/{formId}/documents/{docId}/view_dialog_field/FIELDID/callback_script

**请求包体：**

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| formId        | 是       | 表单id   |
| docid         | 是       | 文档id   |

**权限说明：**

无。

**返回结果：**

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回的表单对象，数据结构参考[\#3.3](#获取pdf文件) |

### 智能搜索提示框-查询
-------------------

>   服务器返回搜索提示相关的信息。

**请求方式：** GET  
**请求地址：** /api/runtime/{applicationId}/forms/{formId}/documents/{docId}/querySuggest

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| formId        | 是       | 表单id   |
| docid         | 是       | 文档id   |

**权限说明：**

无。

**请求包体：**

```
{
    "parentId": "",
    "formFieldId": "11e7-6791-c7a704f6-bb6a-ff15ffadffa1",
    "keyword": "ahah"
}

```

**参数说明：**

| **参数**    | **必须** | **说明**   |
|-------------|----------|------------|
| parentId    | 是       | 父id       |
| formFieldId | 是       | 表单字段id |
| keyword     | 是       | 查询关键字 |

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "name": "选择框1",
            "id": "1"
        },
        {
            "name": "选择框2",
            "id": "2"
        },
        {
            "name": "选择框3",
            "id": "3"
        },
        {
            "name": "选择框4",
            "id": "4"
        },
        {
            "name": "选择框5",
            "id": "5"
        },
        {
            "name": "选择框6",
            "id": "6"
        }
    ]
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 返回的搜索出的提示信息 |


### 获取PDF文件
-----------

通过文件路径获取对应的PDF文件

**请求方式：** GET  
**请求地址：** /api/runtime/file/{fileId}/pdf?path={path}

**参数说明：**

| **参数** | **必须** | **说明** |
|----------|----------|----------|
| fileId   | 是       | 文件id   |
| path     | 是       | 文件路径 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "/uploads/item/2017/123456.pdf"    //PDF的相对路径
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |

### 判断是否配置预览环境(用于在线预览)
-----------

获取是否配置文件预览环境的信息

**请求方式：** GET  
**请求地址：** /api/runtime/files/preview/environment

**参数说明：**

| **参数** | **必须** | **说明** |
|----------|----------|----------|

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": true
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 返回是否配置了预览环境 |

### 判断文件是否存在pdf文件
-----------

通过文件路径和名称判断是否存在对应的PDF文件

**请求方式：** GET  
**请求地址：** /api/runtime/files/hasPdf?path={path}&fileRealName={fileRealName}

**参数说明：**

| **参数** | **必须** | **说明** |
|----------|----------|----------|
| path   | 是       | 文件路径   |
| fileRealName | 是 | 文件真实名称 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": true
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 返回是否存在pdf文件 |

### 水印文件打印
-----------

获取水印文件打印路径

**请求方式：** GET  
**请求地址：** /api/runtime/{applicationId}/documents/{docId}/files/watermark/print

**参数说明：**

| **参数** | **必须** | **说明** |
|----------|----------|----------|
| applicationId   | 是 | 软件id |
| docId | 是 | 文档id |

**请求包体：**

```
{
	"path":"/uploads/item/2019/ef5bcd5e-909a-445-0cad14a7f0be.doc",
	"fileName":"abc.doc",
	"itemId":"vF6Kep6uOGQg0zEzM6U"
}

```

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| path | 是       | 文件路径   |
| fileName        | 是       | 文件名   |
| itemId        | 是       | 字段id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "\\uploads\\item\\2019\\swf\\ef-a7f0beWithWaterMark.pdf"
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 返回pdf文件路径 |

### 表单数据结构说明
----------------

 表单数据结构：

```
{
    "document": {
        "id": "value",
        "formid": "value",
        "applicationid": "value",
        "mappingId": "value",
        "stateid": "value",
        "versions": 1,
        "parentid": "value",
        "authorDeptIndex": "value",
        "stateInt": 0,
        "istmp": false,
        "lastmodified": "value",
        "auditdate": "value",
        "created": "value",
        "authorId": "value",
        "initiator": "value",
        "audituser": "value",
        "lastFlowOperation": 80,
        "stateLabelInfo": "value",
        "auditorList": "value",
        "prevAuditNode": "value",
        "prevAuditUser": "value",
        "sign": "value",
        "items": [
            {
                "name": "value",
                "age": 0,
                "date": "2017-6-23"
            }
        ]
    },
    "activitys": [
        {
            "id": "11e7-4c27-f0b88789-a441-734aa5158162",
            "name": "保存",
            "type": 4
        },
        {
            "id": "11e7-4c27-f0b88789-a441-734aa5158162",
            "name": "提交",
            "type": 8
        }
    ],
    "style": "value",
    "approvers": [
        [
            {
                "instanceId": "11e7-5c9e-f9e93dfc-b2d6-b959e8a4d585",
                "flowName": "测试流程",
                "flowId": "11e6-5fae-abde2740-b3ac-31493634e7af",
                "nodes": [
                    {
                        "nodeId": "1470911349645",
                        "stateLabel": "节点二[标签]",
                        "auditors": [
                            {
                                "id": "11e6-6ab3-19bfcfc3-bcfe-1f3c25384deb",
                                "name": "happy"
                            }
                        ]
                    }
                ]
            }
        ]
    ],
    "html": "htmlencode后的字符串",
    "fields": [
                {
                    "fieldtype": "VALUE_TYPE_VARCHAR",
                    "hiddenValue": "",
                    "borderType": false,
                    "numberPattern": "",
                    "discript": "",
                    "id": "11e7-61ee-2453c635-991c-c72710268258_单行文本_名称",
                    "displayType": 2,
                    "name": "单行文本_名称",
                    "readOnlyShowValOnly": true,
                    "value": "",
                    "cssClass": "input-cmd",
                    "fieldkeyevent": "Tabkey",
                    "textType": "text",
                    "refreshOnChanged": false,
                    "layoutType": "horizontal"
                }
            ]

}

```

**参数说明：**

| **参数**  | **数据类型** | **说明**                                         |
|-----------|--------------|--------------------------------------------------|
| document  | Object       | 文档对象，数据结构参考[\#2.8](#文档数据结构说明) |
| activitys | Array        | 操作按钮集合, 数据结构参考\#4.2.3                |
| style     | String       | 自定义样式表                                     |
| approvers | Array        | 表单节点/处理人信息                              |
| html      | String       | 表单模板（HtmlEncode后的HTML片段代）             |
| fields    | Array        | 控件属性信息                                     |

### 动态表单控件HTML标签名对照表：

1.  TagName以“o-”作为前缀，如文本框控件的tagName为“o-input”。

2.  动态表单控件的属性用自定义属性存储，以“data-”作为前缀，如文本框的“布局方式属性”为“data-layout-type=xxx”

| **控件名**     | **标签名**         | **备注** |
|----------------|--------------------|----------|
| 单行文本框     | o-input            |          |
| 多行文本框     | o-textarea         |          |
| 复选框         | o-checkbox         |          |
| 单选框         | o-radio            |          |
| 下拉框         | o-select           |          |
| 日期选择框     | o-date-picker      |          |
| 部门选择框     | o-dept-select      |          |
| 树形部门选择框 | o-dept-tree-select |          |
| 用户选择框     | o-user-select      |          |
| 左右选择框     | o-                 |          |
| 智能提示搜索框 | o-suggest          |          |
| 按钮           | o-button           |          |
| 视图选择框     | o-view-dialog      |          |
| 选项卡         | o-tab              |          |
| 计算脚本       | o-calctext         |          |
| 包含元素       | o-include          |          |
| 调查控件       | o-survey           |          |
| 文件上传       | o-file-upload      |          |
| 图片上传       | o-image-upload     |          |
| 在线拍照       | o-photo            |          |
| 地图           | o-map              |          |
| 微信GPS定位    | o-gps              |          |
| 二维码         | o-qrcode           |          |
| 录音           | o-record           |          |
| Word编辑器     | o-word             |          |
| HTML编辑器     | o-html             |          |
| 流程审批历史   | o-flow-history     |          |
| 流程催办历史   | o-reminder-history |          |

## 4.  **视图（Views）**

### 获取视图
--------------------
服务器返回包含视图模板、操作、列但不包含视图数据的结果。

**请求方式：** GET  
**请求地址：** /api/runtime/{applicationId}/views/{viewId}/template

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| viewId        | 是       | 视图id   |

**权限说明：**

无。

**返回结果：**

```
{  
  "errcode" : 0,  
  "errmsg" : "ok",
  "data" : {
    "id": "11e7-4c27-fa914816-a441-734aa5158162",
    "name": "测试视图",
    "applicationid": "11e7-473e-7c2149a7-b6ca-1d93db2e7698",
    "openType": 1,
    "pagination": true,
    "pagelines": 10,
    "editMode": "00",
    "showTotalRow": false,
    "relatedForm": "11e7-4c27-e9843316-a441-734aa5158162",
    "refresh": false,
    "readonly": false,
    "viewType": 1,
    "innerType": "FORM",
    "displayType": "relatedForm",
    "showWaterMark": false,
    "showWaterContent":'',
    "style": '',
    "permissionType": "public",
    "activitys": [],
    "columns": []
    }
}

```

**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| errcode  | 返回码                            |
| errmsg   | 对返回码的文本描述内容            |
| data     | 返回的视图对象，数据结构参考\#4.3 |

### 获取视图查询表单模板
--------------------

服务器返回包含视图模板、操作、列但不包含视图数据的结果。

**请求方式：** GET  
**请求地址：** /api/runtime/{applicationId}/views/{viewId}/ searchformtemplate

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| viewId        | 是       | 视图id   |

**权限说明：**

无。

**返回结果：**

```
{  
  "errcode" : 0,  
  "errmsg" : "ok",
  "data" : {
    " fields": [],
    " document": {},
    " template": ".."
    }
}

```

**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| errcode  | 返回码                            |
| errmsg   | 对返回码的文本描述内容            |
| data     | 返回的视图对象，数据结构参考\#4.3 |

### 获取视图数据
------------

服务器返回视图数据的结果。

**请求方式：** POST  
**请求地址：** /api/runtime/{applicationId}/views/{viewId}/documents?parentId={parentId}&sortCol={sortCol}&sortStatus={sortStatus}&parentParam={parentParam}&isMobile={isMobile}&searchWord={searchWord}&lines={lines}startDate={startDate}&endDate={endDate}

**参数说明：**

| **参数**      | **必须** | **说明**                    |
|---------------|----------|-----------------------------|
| applicationId | 是       | 软件id                      |
| viewId        | 是       | 视图id                      |
| parentId      | 否       | 父id                        |
| sortCol       | 否       | 排序列字段                  |
| sortStatus    | 否       | 排序状态(升序DESC或降序ASC) |
| parentParam   | 否       | 折叠视图的上级参数          |
| isMobile   | 否       | 是否移动端          |
| searchWord   | 否       | 搜索关键字（移动端）          |
| lines         | 否       | 每页显示数                  |
| startDate     | 否       | 日历视图开始时间            |
| endDate       | 否       | 日历结束开始时间            |

**权限说明：**

无。

**请求包体：**

```
{
     "KEY": "VALUE",
     "KEY": "VALUE"
}

```

**参数说明：**

| **参数** | **必须** | **说明**           |
|----------|----------|--------------------|
| content  | 是       | Document里面的item |

**返回结果：**

```
{  
  "errcode" : 0,  
  "errmsg" : "ok",
  "data" : []
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 视图文档对象的数据列表 |

### 获取树形视图数据
----------------

服务器返回视图数据的结果。

**请求方式：** POST  
**请求地址：** /api/runtime/{applicationId}/treeviews/{viewId}/documents?parentId={parentId}&name={name}

**参数说明：**

| **参数**      | **必须** | **说明**                    |
|---------------|----------|-----------------------------|
| applicationId | 是       | 软件id                      |
| viewId        | 是       | 视图id                      |
| parentId      | 否       | 父id（父级的docid）                        |
| name | 否 | 节点名称 |

**权限说明：**

无。

**请求包体：**

```
{
     "KEY": "VALUE",
     "KEY": "VALUE"
}
```

**参数说明：**

| **参数** | **必须** | **说明**           |
|----------|----------|--------------------|
| content  | 是       | Document里面的item |

**返回结果：**

```
{  
  "errcode" : 0,  
  "errmsg" : "ok",
  "data" : []
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 视图文档对象的数据列表 |

### 树形视图查询
------------

服务器返回包含视图模板、操作、列但不包含视图数据的结果。

**请求方式：** GET  
**请求地址：** /api/runtime/{applicationId}/views/{viewId}/tree/search?keyword={keyword}

**参数说明：**

| **参数**      | **必须** | **说明**   |
|---------------|----------|------------|
| applicationId | 是       | 软件id     |
| viewId        | 是       | 视图id     |
| keyword       | 否       | 查询关键字 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        "#11e7-735a-8b7d3a04-966a-876161d2b77c"
    ]
}

```
**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 视图id集合             |

### 视图列的提交按钮
--------

>   视图列的提交流程

**请求方式：** POST  
**请求地址：**/api/runtime/{applicationId}/views/{viewId}/column/submit

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| viewId | 是       | 视图id   |

**请求包体：**

```
{
    "docId":"14e7dwq091134ct9635fG",
    "approveLimit":"abc,abb,bbbc",
    "attitude":"222"
}

```

**参数说明：**

| **参数**               | **必须** | **说明**                    |
|------------------------|----------|-----------------------------|
| docId                 | 是       | 文档id                  |
| attitude               | 是       | 提交意见      |
| approveLimit          | 是       | 节点限制id                  |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "成功处理1条,失败0条"
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 流程提交成功的消息     |

### 判断视图打开权限
----------

判断视图是否具有打开权限，返回运算结果（true/false）。

**请求方式：** GET  
**请求地址：** /api/runtime/{applicationId}/views/{viewId}/openable

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| viewId        | 是       | 视图id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": true
}
```

**参数说明：**

| **参数** | **说明**                 |
|----------|--------------------------|
| errcode  | 返回码                   |
| errmsg   | 对返回码的文本描述内容   |
| data     | 返回运算结果，true/false |

### 执行视图选择框确定脚本
----------------

服务器返回视图数据的结果。

**请求方式：** POST  
**请求地址：** /api/runtime/views/selectbox/runViewDialogConfirmScript

**参数说明：**

| **参数**      | **必须** | **说明**                    |
|---------------|----------|-----------------------------|

**权限说明：**

无。

**请求包体：**

```
{
     "_selects": "qweqwe",
     "okScript": "qweqwe",
     "fieldId": "asdas",
     "document": {
        "id":"12312",
        "formId":"ASDAS",
        "items":{
            "单行文本"："asdas"
        }
     }
}
```

**参数说明：**

| **参数** | **必须** | **说明**           |
|----------|----------|--------------------|
| content  | 是       | 包体 |

**返回结果：**

```
{  
  "errcode" : 0,  
  "errmsg" : "ok",
  "data" : "asdas"
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 运算后得出的结果 |

### 执行视图选择框确定回调脚本
----------------

服务器返回视图数据的结果。

**请求方式：** POST  
**请求地址：** /api/runtime/views/selectbox/runViewDialogCallbackScript

**参数说明：**

| **参数**      | **必须** | **说明**                    |
|---------------|----------|-----------------------------|

**权限说明：**

无。

**请求包体：**

```
{
     "_selects": "qweqwe",
     "callbackScript": "qweqwe",
     "fieldId": "asdas",
     "document": {
        "id":"12312",
        "formId":"ASDAS",
        "items":{
            "单行文本"："asdas"
        }
     }
}
```

**参数说明：**

| **参数** | **必须** | **说明**           |
|----------|----------|--------------------|
| content  | 是       | 包体 |

**返回结果：**

```
{  
  "errcode" : 0,  
  "errmsg" : "ok",
  "data" : "asdas"
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 运算后得出的结果 |

### 执行视图列操作按钮的脚本
----------------

服务器返回视图数据的结果。

**请求方式：** POST  
**请求地址：** /api/runtime/{applicationId}/views/{viewId}/columns/{columnId}/runActionScript

**参数说明：**

| **参数**      | **必须** | **说明**                    |
|---------------|----------|-----------------------------|
|applicationId|是|软件id|
|viewId|是|视图id|
|columnId|是|视图列id|

**权限说明：**

无。

**请求包体：**

```
{
    "docId":"asdasdasd",
    "columnName":"asdasdasd"                               			 
}
```

**参数说明：**

| **参数** | **必须** | **说明**           |
|----------|----------|--------------------|
| content  | 是       | 包体 |

**返回结果：**

```
{  
  "errcode" : 0,  
  "errmsg" : "ok",
  "data" : {}
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 运算后得出的结果 |

## 执行视图列操作按钮的执行前脚本
----------------

服务器返回视图数据的结果。

**请求方式：** POST  
**请求地址：** /runtime/{applicationId}/views/{viewId}/columns/{columnId}/beforescript

**参数说明：**

| **参数**      | **必须** | **说明**                    |
|---------------|----------|-----------------------------|
|applicationId|是|软件id|
|viewId|是|视图id|
|columnId|是|视图列id|

**权限说明：**

无。

**请求包体：**

```
{
    "docId":"asdasdasd",
    "columnName":"asdasdasd"                               			 
}
```

**参数说明：**

| **参数** | **必须** | **说明**           |
|----------|----------|--------------------|
| content  | 是       | 包体 |

**返回结果：**

```
{  
  "errcode" : 0,  
  "errmsg" : "ok",
  "data" : {}
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 运算后得出的结果 |

### 视图数据结构说明
----------------

### 视图数据结构：


```
{
        "id": "11e7-4c27-fa914816-a441-734aa5158162",
        "name": "测试视图",
        "applicationid": "11e7-473e-7c2149a7-b6ca-1d93db2e7698",
        "openType": 1,
        "pagination": true,
        "pagelines": 10,
        "editMode": "00",
        "showTotalRow": false,
        "relatedForm": "11e7-4c27-e9843316-a441-734aa5158162",
        "refresh": false,
        "readonly": false,
        "viewType": 1,
        "innerType": "FORM",
        "displayType": "relatedForm",
        "showWaterMark": false,
        "waterMarkText":'',
        "style": '',
        "permissionType": "public",
        "activitys": [],
        "columns": []
    }

```

**参数说明：**

| **参数**         | **数据类型** | **说明**                                       |
|------------------|--------------|------------------------------------------------|
| id               | String       | 视图id                                         |
| name             | String       | 视图名称                                       |
| applicationid    | String       | 软件id                                         |
| openType         | Integer      | 打开类型（当前页、网格、弹出层）               |
| pagination       | Boolean      | 是否分页                                       |
| pagelines        | Integer      | 每页数据行数                                   |
| editMode         | String       | 编辑方式（）                                   |
| showTotalRow     | Boolean      | 是否显示汇总行                                 |
| relatedForm      | String       | 数据来源表单id                                 |
| refresh          | Boolean      | 是否刷新                                       |
| readonly         | Boolean      | 是否只读                                       |
| viewType         | Integer      | 视图类型（列表、日历、树形、地图、分组、甘特） |
| innerType        | String       |                                                |
| displayType      | String       | 呈现方式（数据来源表单、模板表单）             |
| showWaterMark    | Boolean      | 是否显示水印                                   |
| showWaterContent | String       | 水印内容                                       |
| style            | String       | 自定义样式表                                   |
| permissionType   | String       | 授权方式                                       |
| activitys        | Array        | 操作按钮集合，数据结构参考\#4.2.3              |
| columns          | Array        | 列集合,数据结构参考\#4.2.2                     |

### 视图列数据结构：

```
{
        "id": "11e7-4c28-000045da-a441-734aa5158162",
        "name": "name",
        "type": "COLUMN_TYPE_FIELD",
        "formid": "11e7-4c27-e9843316-a441-734aa5158162",
        "fieldName": "name",
        "flowReturnCss": "false",
        "fontColor": "000000",
        "orderno": "1",
        "sum": "false",
        "total": "false",
        "isOrderByField": "false",
        "orderType": "ASC",
        "clickSorting": "true",
        "sortStandard": "00",
        "formatType": "simple",
        "thouSign": "false",
        "color": "000000",
        "fontSize": "12",
        "groundColor": "FFFFFF",
        "showIcon": "false",
        "visible": "true",
        "visible4ExpExcel": "true",
        "visible4Print": "true",
        "visible4PagePrint": "true",
        "showType": "01",
        "displayType": "00",
        "showTitle": "false"
    }

```

**参数说明：**

| **参数**         | **数据类型** | **说明**                                       |
|------------------|--------------|------------------------------------------------|
| id               | String       | 视图id                                         |
| name             | String       | 视图名称                                       |
| applicationid    | String       | 软件id                                         |
| openType         | Integer      | 打开类型（当前页、网格、弹出层）               |
| pagination       | Boolean      | 是否分页                                       |
| pagelines        | Integer      | 每页数据行数                                   |
| editMode         | String       | 编辑方式（）                                   |
| showTotalRow     | Boolean      | 是否显示汇总行                                 |
| relatedForm      | String       | 数据来源表单id                                 |
| refresh          | Boolean      | 是否刷新                                       |
| readonly         | Boolean      | 是否只读                                       |
| viewType         | Integer      | 视图类型（列表、日历、树形、地图、分组、甘特） |
| innerType        | String       |                                                |
| displayType      | String       | 呈现方式（数据来源表单、模板表单）             |
| showWaterMark    | Boolean      | 是否显示水印                                   |
| showWaterContent | String       | 水印内容                                       |
| style            | String       | 自定义样式表                                   |
| permissionType   | String       | 授权方式                                       |
| activitys        | Array        | 操作按钮集合                                   |
| columns          | Array        | 列集合                                         |

### 视图操作数据结构：

```
{
    "id": "11e7-4c28-07f79c2b-a441-734aa5158162",
    "name": "新建",
    "type": "2",
    "onActionForm": "11e7-4c27-e9843316-a441-734aa5158162",
    "colorType": "default",
    "editMode": "0",
    "flowShowType": "ST01",
    "orderno": "1",
    "parentView": "11e7-4c27-fa914816-a441-734aa5158162",
    "jumpType": "0",
    "expSub": "true",
    "disableFlowNode": "true",
    "changeFlowOperator": "true",
    "changeFlowCc": "true",
    "dispatcherMode": "0",
    "jumpMode": "1",
    "jumpActOpenType": "0",
    "withOld": "false",
    "actionType": "0",
    "actionSelection": "0",
    "workFlowType": "0",
    "contextMenu": "false",
    "showInToolbar": "true",
    "transpond": ""

}

```

**参数说明：**

| **参数**         | **数据类型** | **说明**                                       |
|------------------|--------------|------------------------------------------------|
| id               | String       | 视图id                                         |
| name             | String       | 视图名称                                       |
| applicationid    | String       | 软件id                                         |
| openType         | Integer      | 打开类型（当前页、网格、弹出层）               |
| pagination       | Boolean      | 是否分页                                       |
| pagelines        | Integer      | 每页数据行数                                   |
| editMode         | String       | 编辑方式（）                                   |
| showTotalRow     | Boolean      | 是否显示汇总行                                 |
| relatedForm      | String       | 数据来源表单id                                 |
| refresh          | Boolean      | 是否刷新                                       |
| readonly         | Boolean      | 是否只读                                       |
| viewType         | Integer      | 视图类型（列表、日历、树形、地图、分组、甘特） |
| innerType        | String       |                                                |
| displayType      | String       | 呈现方式（数据来源表单、模板表单）             |
| showWaterMark    | Boolean      | 是否显示水印                                   |
| showWaterContent | String       | 水印内容                                       |
| style            | String       | 自定义样式表                                   |
| permissionType   | String       | 授权方式                                       |
| activitys        | Array        | 操作按钮集合                                   |
| columns          | Array        | 列集合                                         |

### 网格视图中刷新一行表单数据

------

刷新表单。

**请求方式：** POST  
**请求地址：** /api/runtime/{applicationId}/views/{viewid}/documents/{docid}/refresh

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| viewId        | 是       | 视图id   |
| docid         | 是       | 文档Id   |
| content       | 是       | 请求内容 |

**权限说明：**

无。

**返回结果：**

```
{  
  "errcode" : 0,  
  "errmsg" : "ok",
  "refresh" : {
    "docid": "14e7dwq091134ct9635fG",
    "viewid": "11e7-66ae-756b2cc9-9cdb-af6bc8266ed2",
    "items": ""
    }
}

```

**参数说明：**

| **参数** | **说明**               |
| -------- | ---------------------- |
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 返回序列号             |

### 

## 5. **工作流（Workflows）**

### 获取文档的流程状态

>   服务器返回文档的流程状态和处理人信息。

**请求方式：** GET  
**请求地址：** /api/runtime/{applicationId}/workflows/{instanceId}/states

**路径参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| instanceId    | 是       | 流程id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "instanceId": "11e7-5c9e-f9e93dfc-b2d6-b959e8a4d585",
        "flowName": "测试流程",
        "flowId": "11e6-5fae-abde2740-b3ac-31493634e7af",
        "nodes": [
            {
                "nodeId": "1470911349645",
                "stateLabel": "节点二[标签]",
                "auditors": [
                    {
                        "id": "11e6-6ab3-19bfcfc3-bcfe-1f3c25384deb",
                        "name": "happy"
                    }
                ]
            }
        ]
    }
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 返回文档的流程状态     |

### 获取文档的流程历史
------------------

>   服务器返回文档的流程历史信息。

**请求方式：** GET  
**请求地址：** /api/runtime/{applicationId}/documents/{docId}/workflows/flowhistorys?content={content}

**参数说明：**

| **参数**      | **必须** | **说明**   |
|---------------|----------|------------|
| applicationId | 是       | 软件id     |
| docId    | 是       | 文档id |
| content | 是 | 查询条件 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "startNodeName": "通过组织指定",
            "targetNodeName": "通过角色指定",
            "auditorName": "张强",
            "auditorId": "11e7-5f9a-cc4b2b49-917f-e799edecb417",
            "agentAuditorName": null,
            "attitude": "",
            "signature": "",
            "processtime": 1501608073000,
            "flowOperation": "80",
            "folowStateId": "11e7-76dd-cefc7139-aa03-c5c684d033ca",
            "historyId": "11e7-76dd-d184f0e0-aa03-c5c684d033ca",
            "startNodeId": "1499322276773",
            "targetNodeId": "1499322294264",
            "signatureImageDate": ""
        }
    ]
}

```

**参数说明：**

| **参数** | **说明**                     |
|----------|------------------------------|
| errcode  | 返回码                       |
| errmsg   | 对返回码的文本描述内容       |
| data     | 返回文档的流程历史对象的集合 |

### 获取文档的流程图
------------------

>   服务器返回文档的流程图。

**请求方式：** GET  
**请求地址：** /api/runtime/{applicationId}/documents/{docId}/workflows/{instanceId}/flowchart
**参数说明：**

| **参数**      | **必须** | **说明**   |
|---------------|----------|------------|
| applicationId | 是       | 软件id     |
| docId    | 是       | 文档id |
| instanceId    | 是       | 流程实例id |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
            "currentFlowChart": "当前流程图",
            "parentFlowChart": "主流程图"
    }
}

```

**参数说明：**

| **参数** | **说明**                     |
|----------|------------------------------|
| errcode  | 返回码                       |
| errmsg   | 对返回码的文本描述内容       |
| data     | 返回文档的流程图对象 |

### 获取文档的催办记录
------------------

>   服务器返回文档的催办信息。

**请求方式：** GET  
**请求地址：**/api/runtime/{applicationId}/documents/{docId}/workflows/remind-historys

**参数说明：**

| **参数**      | **必须** | **说明**   |
|---------------|----------|------------|
| applicationId | 是       | 软件id     |
| docId    | 是       | 文档id |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "id": "11e7-6f8f-98272c56-966a-876161d2b77c",
            "content": "aaaa",
            "userId": "11e7-5f9a-210f9112-917f-e799edecb417",
            "userName": "李玲",
            "nodeName": "审批人",
            "docId": "11e7-6947-93c5aeca-8a83-bf38d96990bd",
            "flowInstanceId": "11e7-6947-96178e0f-8a83-bf38d96990bd",
            "processTime": 1500804818000
        }
    ]
}

```

**参数说明：**

| **参数**           | **说明**                                   |
|--------------------|--------------------------------------------|
| errcode            | 返回码                                     |
| errmsg             | 对返回码的文本描述内容                     |
| data               | 流程提交面板信息                           |
| currentNodeId      | 当前节点id                                 |
| isSplit            | 当前节点是否为分散节点                     |
| splitToken         | 分散节点token信息（非分散节点值为空）      |
| nextNodes          | 下一步节点的集合                           |
| id                 | 节点id                                     |
| name               | 节点名称                                   |
| type               | 节点类型（ManualNode、AutoNode、SubNode）  |
| isToPerson         | 是否指定审批人                             |
| isAppentCirculator | 是否抄送                                   |
| checked            | 是否默认选中                               |
| locked             | 是否锁定节点选中状态（锁定时不能取消选中） |


### 获取文档的流程提交面板
----------------------

>   服务器返回当前文档流程面板所需要的全部信息，包含当前节点信息，下一步节点的相信配置信息。

**请求方式：** POST  
**请求地址：** /api/runtime/{applicationId}/documents/{docId}/panels/submission

请求格式:
```
{
document: {
        "id": "value",
        "formid": "value",
        "applicationid": "value",
        "stateid": "value",
        "versions": 0,
        "parentid": "value",
        "sign": "value",
        "items": [
            {
                "name": "demo",
                "age": 18,
                "date": "2017-6-23"
            }
        ]
    }
}

```


**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| docId         | 是       | 文档id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "currentNodeId": "1470911344557",
        "flowId": "11e7-6622-7ab2d220-9cdb-af6bc8266ed2",
        "isSplit": false,
        "splitToken": "",
        "nextNodes":[
            {
                "id": "1470911349645",
                "name": "节点二",
                "type": "ManualNode",
                "isToPerson": false,
                "isAppentCirculator": false,
                "checked": true,
                "locked": false,
            },
            {
                "id": "1470911349645",
                "name": "子流程节点",
                "type": "SubNode",
                "isToPerson": false,
                "isAppentCirculator": false,
                "checked": true,
                "locked": false,
                "instanceSettingType": "01",
                "instanceTotal": 1
            }
        ]

    }
}

```

**参数说明：**

| **参数**           | **说明**                                   |
|--------------------|--------------------------------------------|
| errcode            | 返回码                                     |
| errmsg             | 对返回码的文本描述内容                     |
| data               | 流程提交面板信息                           |
| currentNodeId      | 当前节点id                                 |
| isSplit            | 当前节点是否为分散节点                     |
| splitToken         | 分散节点token信息（非分散节点值为空）      |
| nextNodes          | 下一步节点的集合                           |
| id                 | 节点id                                     |
| name               | 节点名称                                   |
| type               | 节点类型（ManualNode、AutoNode、SubNode）  |
| isToPerson         | 是否指定审批人                             |
| isAppentCirculator | 是否抄送                                   |
| checked            | 是否默认选中                               |
| locked             | 是否锁定节点选中状态（锁定时不能取消选中） |


### 获取文档的流程回退面板
----------------------

>   服务器返回当前文档流程面板所需要的全部信息，包含当前节点信息，下一步节点的相关配置信息。

**请求方式：** POST  
**请求地址：**/api/runtime/{applicationId}/document/{docId}/panels/back

请求格式:
```
{
document: {
        "id": "value",
        "formid": "value",
        "applicationid": "value",
        "stateid": "value",
        "versions": 0,
        "parentid": "value",
        "sign": "value",
        "items": [
            {
                "name": "demo",
                "age": 18,
                "date": "2017-6-23"
            }
        ]
    }
}

```

**参数说明：**

| **参数**      | **必须** | **说明**   |
|---------------|----------|------------|
| applicationId | 是       | 软件id     |
| docId    | 是       | 文档id |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "currentNodeId": "1470911344557",
        "isSplit": false,
        "splitToken": "",
        "nextNodes":[
            {
                "id": "1470911349645",
                "name": "节点二",
                "type": "ManualNode",
      
            }
        ]

    }
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 返回流程回退面板信息   |

### 获取文档的流程发起面板
----------------------

服务器返回当前文档流程发起面板所需要的全部信息，包含启动的流程列表信息。

**请求方式：** GET  
**请求地址：**/api/runtime/{applicationId}/documents/{docId}/panels/initiate

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| docid         | 是       | 文档id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "id": "1470911349645",
            "name": "请假流程1",
            "firstNodeList":[
                    {
                    "id":"id1",
                    "name":"name1"
                    },
                    {
                    "id":"id2",
                    "name":"name2"
                    }
                ]
        },
        {
            "id": "1470911349645",
            "name": "请假流程2",
            "firstNodeList":[
                    {
                    "id":"id3",
                    "name":"name3"
                    },
                    {
                    "id":"id4",
                    "name":"name4"
                    }
                ]
        }
    ]
}

```

**参数说明：**

| **参数**      | **说明**               |
|---------------|------------------------|
| errcode       | 返回码                 |
| errmsg        | 对返回码的文本描述内容 |
| data          | 返回流程发起面板信息   |
| id            | 流程id                 |
| name          | 流程名称               |
| firstNodeList | 开始节点列表           |

### 发起流程
--------

>   保存文档并发起流程。

**请求方式：** POST  
**请求地址：**/api/runtime/{applicationId}/documents/{docId}/workflows/initiate

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| docid         | 是       | 文档id   |

**请求包体：**

```
{
    "actid":"14e7dwq091134ct9635fG",
    "flowId":"14e7dwq091134ct9635fG",
    "nextId":"14e7dwq091134ct9635fG",
    "flowType":"1",
    "document":{
        "id": "value",
        "formid": "value",
        "applicationid": "value",
        "stateid": "value",
        "versions": 0,
        "parentid": "value",
        …//其他系统字段
        "sign": "value",
        "items": [
            {
                "name": "demo",
                "age": 18,
                "date": "2017-6-23"
            }
        ]
    }
}   

```

**参数说明：**

| **参数** | **必须** | **说明**                    |
|----------|----------|-----------------------------|
| actid    | 是       | 流程发起的按钮id            |
| flowId   | 是       | 流程定义id                  |
| flowType | 是       | 流程处理动作代码（1）       |
| document | 是       | 文档对象，数据结构参考\#2.8 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "启动成功"
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 发起流程的成功消息     |

### 提交流程
--------

>   保存文档并提交流程。

**请求方式：** PUT  
**请求地址：**/api/runtime/{applicationId}/documents/{docId}/workflows/submit

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| docid         | 是       | 文档id   |

**请求包体：**

```
{
    "flowId":"14e7dwq091134ct9635fG",
    "flowType":"80",
    "currentNodeId":"1470911349635",
    "nextNodeIds":["1470911349645","1470911349644"],
    "attitude":"",
    "signature":"",
    "submitTo": "",
    "circulatorInfo":"",
    "subFlowApproverInfo":"",
    "subFlowApproverInfoAll":""
    "document":{
        "id": "value",
        "formid": "value",
        "applicationid": "value",
        "stateid": "value",
        "versions": 0,
        "parentid": "value",
        …//其他系统字段
        "sign": "value",
        "items": [
            {
                "name": "demo",
                "age": 18,
                "date": "2017-6-23"
            }
        ]
    }
}

```

**参数说明：**

| **参数**               | **必须** | **说明**                    |
|------------------------|----------|-----------------------------|
| flowId                 | 是       | 流程定义id                  |
| flowType               | 是       | 流程处理动作代码（80）      |
| currentNodeId          | 是       | 当前节点id                  |
| nextNodeIds            | 是       | 下一步节点id集合            |
| attitude               | 否       | 提交备注                    |
| signature              | 否       | 手写签名                    |
| submitTo               | 否       | 指定审批人                  |
| circulatorInfo         | 否       | 指定抄送人                  |
| subFlowApproverInfo    | 否       | 指定子流程审批人            |
| subFlowApproverInfoAll | 否       | 指定所有子流程节点审批人    |
| document               | 是       | 文档对象，数据结构参考\#2.8 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "提交成功"
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 流程提交成功的消息     |

### 催办流程
--------

>   保存文档并流程催办。

**请求方式：** PUT  
**请求地址：**/api/runtime/{applicationId}/documents/{docId}/workflows/remind

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| docid         | 是       | 文档id   |

**请求包体：**

```
{
    "reminderContent":"zz",
    "nodertIds":["1470911349645","1470911349644"]
}

```

**参数说明：**

| **参数**  | **必须** | **说明**                    |
|-----------|----------|-----------------------------|
| nodertIds | 是       | 节点id集合                  |
| document  | 是       | 文档对象，数据结构参考\#2.8 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "催办成功"
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 流程催办成功的消息     |

### 回退流程
--------

>   保存文档并回退流程。

**请求方式：** PUT  
**请求地址：**/api/runtime/{applicationId}/documents/{docId}/workflows/back

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| docid         | 是       | 文档id   |

**请求包体：**

```
{
    "flowId":"14e7dwq091134ct9635fG",
    "flowType":"81",
    "currentNodeId":"1470911349635",
    "nextNodeIds":["1470911349645"],
    "attitude":"",
    "signature":"",
    "document":{
        "id": "value",
        "formid": "value",
        "applicationid": "value",
        "stateid": "value",
        "versions": 0,
        "parentid": "value",
        …//其他系统字段
        "sign": "value",
        "items": [
            {
                "name": "demo",
                "age": 18,
                "date": "2017-6-23"
            }
        ]
    }
}

```

**参数说明：**

| **参数**      | **必须** | **说明**                    |
|---------------|----------|-----------------------------|
| flowId        | 是       | 流程定义id                  |
| flowType      | 是       | 流程处理动作代码(81)        |
| currentNodeId | 是       | 当前节点id                  |
| nextNodeIds   | 是       | 下一步节点id集合            |
| attitude      | 否       | 提交备注                    |
| signature     | 否       | 手写签名                    |
| document      | 是       | 文档对象，数据结构参考\#2.8 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "回退成功"
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 流程回退成功的消息     |

### 撤回流程
--------

>   保存文档并撤回流程。

**请求方式：** PUT  
**请求地址：**/api/runtime/{applicationId}/documents/{docId}/workflows/retracement

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| docid         | 是       | 文档id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "撤回成功"
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 流程撤回成功的消息     |

### 终止流程
--------

>   保存文档并终止流程。

**请求方式：** PUT  
**请求地址：**/api/runtime/{applicationId}/documents/{docId}/workflows/termination

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| docid         | 是       | 文档id   |
| attitude         | 否       | 意见   |
| signature         | 否       | 签名   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "终止成功"
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 终止流程返回的信息     |

### 挂起流程
--------

>   保存文档并挂起流程。

**请求方式：** PUT  
**请求地址：**/api/runtime/{applicationId}/documents/{docId}/suspend

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| docid         | 是       | 文档id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "挂起成功"
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 流程挂起成功的消息     |

### 恢复流程
--------

**请求方式：** PUT  
**请求地址：**/api/runtime/{applicationId}/documents/{docId}/recovery

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| docid         | 是       | 文档id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "恢复成功"
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 流程恢复成功的消息     |

### 自由流程-发起
-------------

**请求方式：** POST  
**请求地址：**/api/runtime/{applicationId}/documents/{docId}/freeflows/initiate

**路径参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| docid         | 是       | 文档id   |

**请求包体：**

```
{
    "flowType":"1",
    "nextUserId":"sf34sdsfKJg342",
    "attitude":"提交备注",
    "document":{
     "id": "value",
        "formid": "value",
        "applicationid": "value",
        "stateid": "value",
        "versions": 0,
        "parentid": "value",
        …//其他系统字段
        "sign": "value",
        "items": [
            {
                "name": "demo",
                "age": 18,
                "date": "2017-6-23"
            }
        ]
    }
}

```

**参数说明：**

| **参数**   | **必须** | **说明**                    |
|------------|----------|-----------------------------|
| flowType   | 是       | 提交动作代码                |
| nextUserId | 是       | 下一步处理人id              |
| attitude   | 否       | 提交备注                    |
| document   | 是       | 文档对象，数据结构参考\#2.8 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "自由流程发起成功"
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 自由流程发起返回的信息 |

### 自由流程-提交
-------------

**请求方式：** PUT  
**请求地址：**/api/runtime/{applicationId}/documents/{docId}/freeflows/submit

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| docid         | 是       | 文档id   |

**请求包体：**

```
{
    "flowType":"80",
    "nextUserId":"sf34sdsfKJg342",
    "attitude":"",
    "document":{
        "id": "value",
        "formid": "value",
        "applicationid": "value",
        "stateid": "value",
        "versions": 0,
        "parentid": "value",
        …//其他系统字段
        "sign": "value",
        "items": [
            {
                "name": "demo",
                "age": 18,
                "date": "2017-6-23"
            }
        ]
    }
}

```

**参数说明：**

| **参数**   | **必须** | **说明**                    |
|------------|----------|-----------------------------|
| flowType   | 是       | 提交动作代码（80）          |
| nextUserId | 是       | 下一步处理人id              |
| attitude   | 否       | 提交备注                    |
| document   | 是       | 文档对象，数据结构参考\#2.8 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "自由流程提交成功"
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 自由流程提交返回的信息 |

### 自由流程-回退
-------------

**请求方式：** PUT  
**请求地址：**/api/runtime/{applicationId}/documents/{docId}/freeflows/back

**路径参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| docid         | 是       | 文档id   |

**请求包体：**

```
{
    "flowType":"81",
    "nextUserId":"sf34sdsfKJg342",
    "attitude":"",
    "document":{
        "id": "value",
        "formid": "value",
        "applicationid": "value",
        "stateid": "value",
        "versions": 0,
        "parentid": "value",
        …//其他系统字段
        "sign": "value",
        "items": [
            {
                "name": "demo",
                "age": 18,
                "date": "2017-6-23"
            }
        ]
    }
}

```

**参数说明：**

| **参数**   | **必须** | **说明**                    |
|------------|----------|-----------------------------|
| flowType   | 是       | 提交动作代码（81）          |
| nextUserId | 是       | 下一步处理人id              |
| attitude   | 否       | 提交备注                    |
| document   | 是       | 文档对象，数据结构参考\#2.8 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "自由流程回退成功"
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 自由流程回退返回的信息 |

### 自由流程-归档（结束）
---------------------

**请求方式：** PUT  
**请求地址：**/api/runtime/{applicationId}/documents/{docId}/freeflows/complete

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| docid         | 是       | 文档id   |

**请求包体：**

```
{
    "flowType":"7",
    "attitude":"",
    "document":{
        "id": "value",
        "formid": "value",
        "applicationid": "value",
        "stateid": "value",
        "versions": 0,
        "parentid": "value",
        …//其他系统字段
        "sign": "value",
        "items": [
            {
                "name": "demo",
                "age": 18,
                "date": "2017-6-23"
            }
        ]
    }
}

```

**参数说明：**

| **参数** | **必须** | **说明**                    |
|----------|----------|-----------------------------|
| flowType | 是       | 提交动作代码（7）           |
| attitude | 否       | 提交备注                    |
| document | 是       | 文档对象，数据结构参考\#2.8 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "自由流程结束成功"
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 自由流程结束返回的信息 |

### 更新流程节点审批人
------------------

**请求方式：** PUT  
**请求地址：**/api/runtime/{applicationId}/documents/{docId}/workflows/approvers

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| docid         | 是       | 文档id   |

**请求包体：**

```
{
  
    "auditorList":["123123","123123"]
}

```

**参数说明：**

| **参数**    | **必须** | **说明**   |
|-------------|----------|------------|
| auditorList | 是       | 审批人集合 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "修改成功"
}

```

**参数说明：**

| **参数** | **说明**                 |
|----------|--------------------------|
| errcode  | 返回码                   |
| errmsg   | 对返回码的文本描述内容   |
| data     | 编辑审批人成功返回的信息 |

### 获取自由流程可回退用户
------------------

**请求方式：** GET  
**请求地址：**/api/runtime/{applicationId}/workflows/{instanceId}/hisActorsFreeFlow

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| instanceId    | 是     | 流程实例id |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "id": "11e4-63ff-5d9df2ad-9f19-57d7b83ae7be",
            "name": "admin",
            "type": 1,
            "mobile": "",
            "mobile2": null,
            "email": "",
            "avatar": "",
            "dept": "产品部",
            "deptId": "11e8-46a9-a3c6c4f2-94a7-9b60038597d7",
            "loginNo": "admin1",
            "domainId": "11e1-81e2-37f74759-9124-47aada6b7467",
            "pcmEnable": true,
            "domainAdmin": false
        }
    ]
}

```

**参数说明：**

| **参数** | **说明**                 |
|----------|--------------------------|
| errcode  | 返回码                   |
| errmsg   | 对返回码的文本描述内容   |
| data     | 可回退的用户列表 |

### 获取流程指定审批人用户选择框列表
------------------

**请求方式：** GET  
**请求地址：**/api/runtime/{applicationId}/documents/{docId}/workflows/{flowId}/selectApprovers

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| docId    | 是     | 文档id |
| flowId | 是       | 流程id   |
| nodeId | 是       | 节点id   |
| type | 是       | 类型（3:查询;2:角色;1:部门;0:默认所有;） |
| selectId | 否       | 点击角色或者部门时选中id   |
| pageNum | 否       | 当前页   |
| pageSize | 否       | 每页显示数据数   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "datas": [
            {
            "id": "11e4-63ff-5d9df2ad-9f19-57d7b83ae7be",
            "name": "admin",
            "type": 1,
            "mobile": "",
            "mobile2": null,
            "email": "",
            "avatar": "",
            "dept": "产品部",
            "deptId": "11e8-46a9-a3c6c4f2-94a7-9b60038597d7",
            "loginNo": "admin1",
            "domainId": "11e1-81e2-37f74759-9124-47aada6b7467",
            "pcmEnable": true,
            "domainAdmin": false
        }
        ],
        "pageCount": 1,
        "rowCount": 2,
        "pageNum": 1,
        "linesPerPage": 5
    }
}

```

**参数说明：**

| **参数** | **说明**                 |
|----------|--------------------------|
| errcode  | 返回码                   |
| errmsg   | 对返回码的文本描述内容   |
| data     | 审批人用户列表 |

### 获取流程指定抄送人用户选择框列表

------

**请求方式：** GET  
**请求地址：**/api/runtime/{applicationId}/documents/{docId}/workflows/{flowId}/selectCirculators

**参数说明：**

| **参数**      | **必须** | **说明**                      |
| ------------- | -------- | ----------------------------- |
| applicationId | 是       | 软件id                        |
| docId         | 是       | 文档id                        |
| flowId        | 是       | 流程id                        |
| nodeId        | 是       | 节点id                        |
| type          | 是       | 类型（3:查询;2:角色;1:部门;） |
| selectId      | 否       | 点击角色或者部门时选中id      |
| pageNum       | 否       | 当前页                        |
| pageSize      | 否       | 每页显示数据数                |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "datas": [
            {
            "id": "11e4-63ff-5d9df2ad-9f19-57d7b83ae7be",
            "name": "admin",
            "type": 1,
            "mobile": "",
            "mobile2": null,
            "email": "",
            "avatar": "",
            "dept": "产品部",
            "deptId": "11e8-46a9-a3c6c4f2-94a7-9b60038597d7",
            "loginNo": "admin1",
            "domainId": "11e1-81e2-37f74759-9124-47aada6b7467",
            "pcmEnable": true,
            "domainAdmin": false
        }
        ],
        "pageCount": 1,
        "rowCount": 2,
        "pageNum": 1,
        "linesPerPage": 5
    }
}

```

**参数说明：**

| **参数** | **说明**               |
| -------- | ---------------------- |
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 审批人用户列表         |

### 添加/补签意见

------------------

**请求方式：** PUT  
**请求地址：**/api/runtime/{applicationId}/workflows/{instanceId}/supplement?comments={comments}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| instanceId    | 是     | 流程实例id |
| comments | 是       | 补签意见   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "成功"
}

```

**参数说明：**

| **参数** | **说明**                 |
|----------|--------------------------|
| errcode  | 返回码                   |
| errmsg   | 对返回码的文本描述内容   |
| data     | 补签成功信息 |

### 流程协办
------------------

**请求方式：** PUT  
**请求地址：**/api/runtime/{applicationId}/workflows/{instanceId}/assist?attitude={attitude}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| instanceId    | 是     | 流程实例id |
| attitude | 是       | 补签意见   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "成功"
}

```

**参数说明：**

| **参数** | **说明**                 |
|----------|--------------------------|
| errcode  | 返回码                   |
| errmsg   | 对返回码的文本描述内容   |
| data     | 协办成功信息 |

### 流程协办加签
------------------

**请求方式：** PUT  
**请求地址：**/api/runtime/{applicationId}/documents/{docId}/workflows/assist/addition

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| docId    | 是     | 文档id |

**请求包体：**

```
[
  
    "id1",
    "id2",
    "id3"
]

```

**参数说明：**

| **参数**    | **必须** | **说明**   |
|-------------|----------|------------|
| userIds | 是       | 加签人集合 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "成功"
}

```

**参数说明：**

| **参数** | **说明**                 |
|----------|--------------------------|
| errcode  | 返回码                   |
| errmsg   | 对返回码的文本描述内容   |
| data     | 加签成功信息 |

### 流程主办加签
------------------

**请求方式：** PUT  
**请求地址：**/api/runtime/{applicationId}/documents/{docId}/workflows/approver/addition

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| docId    | 是     | 文档id |

**请求包体：**

```
[
  
    "id1",
    "id2",
    "id3"
]

```

**参数说明：**

| **参数**    | **必须** | **说明**   |
|-------------|----------|------------|
| userIds | 是       | 加签人集合 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "成功"
}

```

**参数说明：**

| **参数** | **说明**                 |
|----------|--------------------------|
| errcode  | 返回码                   |
| errmsg   | 对返回码的文本描述内容   |
| data     | 加签成功信息 |

### 流程仪表查询

------

**请求方式：** POST
**请求地址：**/api/runtime/{applicationId}/Consuming

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| content       | 是       | 请求包体 |

**请求包体：**

```
{ 
	"select": "Status", 
	"startdate": "startDate",
	"enddate": "endDate",
	"application": "applicationid", 
	"showMode": "ShowMode",
	"dateRange": "DateRange"
}

```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "echart": {
                "number": "2",
                "consuming": [
                    "0.00",
                    "0.00"
                ],
                "yAxis": [
                    "0.00",
                    "0.00"
                ],
                "xAxis": [
                    "发文_并行选中",
                    "并行聚合自动节点"
                ],
                "num": [
                    2,
                    5
                ]
            },
            "table": [
                {
                    "core": "1",
                    "consuming": "0.00",
                    "number": "2",
                    "consumingday": "0.00",
                    "flowname": "发文_并行选中",
                    "statelabel": "未完成"
                },
                {
                    "core": "2",
                    "consuming": "0.00",
                    "number": "5",
                    "consumingday": "0.00",
                    "flowname": "并行聚合自动节点",
                    "statelabel": "未完成"
                }
            ]
        }
    ]
}

```

**参数说明：**

| **参数** | **说明**               |
| -------- | ---------------------- |
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 流程仪表数据           |

## 6. **操作（Activitys）**

###  运行动作执行前脚本

>   服务器返回包含表单模板、操作、样式库、数据、权限（数据与权限体现在表单控件的属性）的结果。

**请求方式：** POST  
**请求地址：**/api/runtime/{applicationId}/activities/{id}/runbeforeactionscript

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| id            | 是       | 按钮id   |

**权限说明：**

无。

**请求包体：**

```
{
   "document":{
        "id": "value",
        "formid": "value",
        "applicationid": "value",
        "stateid": "value",
        "versions": 0,
        "parentid": "value",
        …//其他系统字段
        "sign": "value",
        "items": [
            {
                "name": "demo",
                "age": 18,
                "date": "2017-6-23"
            }
        ]
    },
	"docId": "",
    "viewId": "PeHAwXgRVH5kH657J8z",
    "formId": "51uwxPwK7QwxkiH5SYH",
    "templateForm": "",
    "parentId": "",
    "_selects": [],
    "isRelate": ""
}

```

**参数说明：**

无。

**返回结果：**

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回的表单对象，数据结构参考[\#3.3](#获取pdf文件) |

### 运算动作执行后脚本
------------------

>   服务器返回包含表单模板、操作、样式库、数据、权限（数据与权限体现在表单控件的属性）的结果。

**请求方式：** POST  
**请求地址：**/api/runtime/{applicationId}/activities/{id}/runafteractionscript

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| id            | 是       | 按钮id   |

**权限说明：**

无。
**请求包体：**

```
{
   "document":{
        "id": "value",
        "formid": "value",
        "applicationid": "value",
        "stateid": "value",
        "versions": 0,
        "parentid": "value",
        …//其他系统字段
        "sign": "value",
        "items": [
            {
                "name": "demo",
                "age": 18,
                "date": "2017-6-23"
            }
        ]
    },
	"docId": "",
    "viewId": "PeHAwXgRVH5kH657J8z",
    "formId": "51uwxPwK7QwxkiH5SYH",
    "templateForm": "",
    "parentId": "",
    "_selects": [],
    "isRelate": ""
}

```

**参数说明：**

无。

**返回结果：**

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回的表单对象，数据结构参考[\#3.3](#获取pdf文件) |

### 运算自定义动作脚本
------------------

>   服务器返回包含表单模板、操作、样式库、数据、权限（数据与权限体现在表单控件的属性）的结果。

**请求方式：** PUT  
**请求地址：**/api/runtime/{applicationId}/activities/{id}/execute?docId={docId}&viewId={viewId}&formId={formId}&_templateForm={_templateForm}&parentId={parentId}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| id            | 是       | 按钮id   |

**权限说明：**

无。

**请求包体：**

```
{
    "document": {
        "items": {
            "名称": "",
            "单价": "",
            "库存": "",
            "备注": ""
        },
        "applicationId": "sOZu9kthmxyP8qQfq0e",
        "id": "__N3YqDVkwiYykKyVnVks",
        "templateForm": "",
        "formId": "PlyzrsgHnCVr21PPKDQ",
        "sign": "",
        "parentId": "",
        "isRelate": "undefined",
        "subDocuments": [],
        "versions": "0"
    },
    "formId": "PlyzrsgHnCVr21PPKDQ",
    "docId": "__N3YqDVkwiYykKyVnVks",
    "parentId": "",
    "templateForm": "",
    "viewId": "",
    "applicationId": "sOZu9kthmxyP8qQfq0e",
    "id": "__N3YqDVkwiYykKyVnVks"
}

```

**返回结果：**

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回的表单对象，数据结构参考[\#3.3](#获取pdf文件) |

### 运算操作某字段执行脚本

**请求方式：** GET  
**请求地址：**/api/runtime/{applicationId}/activities/{id}/runScript？docId={docId}&fieldName={fieldName}

**参数说明：**

| **参数**      | **必须** | **说明**     |
| ------------- | -------- | ------------ |
| applicationId | 是       | 软件id       |
| id            | 是       | 按钮id       |
| docId         | 是       | 文档         |
| fieldName     | 是       | 操作某字段名 |

**权限说明：**

无。

**请求包体：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": "https://www.baidu.com?sss=njhkjhj"
}


```

**参数说明：**

无。

**返回结果：**

**参数说明：**

| **参数** | **说明**                                          |
| -------- | ------------------------------------------------- |
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回的表单对象，数据结构参考[\#3.3](#获取pdf文件) |

### 保存并启动流程

--------------

**请求方式：** POST  
**请求地址：**/api/runtime/{applicationId}/documents/activities/saveStartWorkFlow

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |

**权限说明：**

无。

**请求包体：**

```
{
    "document":{
        "id": "value",
        "formid": "value",
        "applicationid": "value",
        "stateid": "value",
        "versions": 0,
        "parentid": "value",
        …//其他系统字段
        "sign": "value",
        "items": [
            {
                "name": "demo",
                "age": 18,
                "date": "2017-6-23"
            }
        ]
    }
}

```

**参数说明：**

| **参数** | **必须** | **说明**                    |
|----------|----------|-----------------------------|
| document | 是       | 文档对象，数据结构参考\#2.8 |

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": null
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | null                   |

### 复制
----

>   服务器返回文档信息的结果。

**请求方式：** POST  
**请求地址：**/api/runtime/{applicationId}/documents/{docId}/activities/copy

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| docId         | 是       | 文档id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "value",
        "formid": "value",
        "applicationid": "value",
        "stateid": "value",
        "versions": 1,
        "parentid": "value",
        "authorDeptIndex": "value",
        "stateInt": 0,
        "istmp": false,
        "lastmodified": "value",
        "auditdate": "value",
        "created": "value",
        "authorId": "value",
        "initiator": "value",
        "audituser": "value",
        "lastFlowOperation": 80,
        "stateLabelInfo": "value",
        "auditorList": "value",
        "prevAuditNode": "value",
        "prevAuditUser": "value",
        "sign": "value",
        "items": [
            {
                "name": "value",
                "age": 0,
                "date": "2017-6-23"
            }
        ]
    }
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回的表单对象，数据结构参考[\#3.3](#获取pdf文件) |

### 归档
----

**请求方式：** GET  
**请求地址：**/api/runtime/{applicationId}/documents/{docId}/activities/archive

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| docId         | 是       | 文档id   |

**权限说明：**

无。

**返回结果：**

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 返回归档成功的信息     |

### 清除所有数据
------------

**请求方式：** DELETE  
**请求地址：**/api/runtime/{applicationId}/forms/{formId}/activities/clear

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| formId        | 是       | 表单id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "清除成功"
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | null                   |

### 签章
----

**请求方式：** POST  
**请求地址：**/api/runtime/{applicationId}/documents/{docId}/activities/sign

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| docId         | 是       | 文档id   |

**权限说明：**

无。

**请求包体：**

```
{
    "document":{
        "id": "value",
        "formid": "value",
        "applicationid": "value",
        "stateid": "value",
        "versions": 0,
        "parentid": "value",
        …//其他系统字段
        "sign": "value",
        "items": [
            {
                "name": "demo",
                "age": 18,
                "date": "2017-6-23"
            }
        ]
    }
}

```

**参数说明：**

| **参数** | **必须** | **说明**                    |
|----------|----------|-----------------------------|
| document | 是       | 文档对象，数据结构参考\#2.8 |

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "签章成功"
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | null                   |

### 通过邮件或手机短信分享
----------------------

**请求方式：** POST  
**请求地址：**/api/runtime/{applicationId}/documents/{docId}/activities/share

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| docId         | 是       | 文档id   |

**权限说明：**

无。

**请求包体：**

```
{
    "transpond":"11e7-687f-062850be-8a83-bf38d96990bd",
    "handleUrl":"http://localhost:8080/obpm/..",
    "receiverid":"11e7-5f9a-74ef9518-917f-e799edecb417",
    "email":true,
    "msm":false,

}

```

**参数说明：**

| **参数**   | **必须** | **说明**          |
|------------|----------|-------------------|
| transpond  | 是       | 转载id            |
| handleUrl  | 是       | 处理的url         |
| receiverid | 是       | 接受人id          |
| email      | 是       | email分享（布尔） |
| msm        | 是       | 短信分享（布尔）  |

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "发送成功"
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | null                   |

### 文件下载
--------

**请求方式：** POST  
**请求地址：**/api/runtime/{applicationId}/activities/{id}/download?docId={docId}&actId={actId}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| docId         | 否       | 文档id   |
| actId         | 是       | 按钮id   |
| id         | 是       | 按钮id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "文件路径"
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 文件路径               |

### 批量审批
--------

**请求方式：** POST  
**请求地址：**/api/runtime/{applicationId}/forms/activities/batchApprove

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |

**权限说明：**

无。

**请求包体：**

```
{
    "limistStrList":"",
    "docIds":[1SpJQzWvwynv8aqWprb, XTuIPs7RxseePzK6Qvs],
    "actId":"11e7-5f9a-74ef9518-917f-e799edecb417",
    "attitude":"提交意见",
    "remark":"",

}

```

**参数说明：**

| **参数**      | **必须** | **说明**           |
|---------------|----------|--------------------|
| limistStrList | 是       | 下一个节点限制列表 |
| docIds        | 是       | 文档标识数组       |
| actId         | 是       | 按钮id             |
| attitude      | 是       | 提交意见           |
| remark        | 否       | 评论               |

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "处理成功信息"
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 处理成功信息           |

### Pdf导出
-------

**请求方式：** POST  
**请求地址：**/api/runtime/{applicationId}/forms/{formId}/documents/{docId}/activities/exportPdf

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| formId        | 是       | 表单id   |
| docId         | 是       | 文档id   |

**权限说明：**

无。

**请求包体：**

```
{
    "htmlBody":""
}

```

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": ""
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | Null                   |

### Excel导出
---------

**请求方式：** POST  
**请求地址：**/api/runtime/{applicationId}/views/{viewId}/activities/exportExcel?actId={actId}&filename={filename}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| viewId        | 是       | 视图id   |
| actId         | 是       | 按钮id   |
| filename      | 是       | 文件名   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": ""
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | Null                   |

### Excel导入
---------

**请求方式：** POST  
**请求地址：**/api/runtime/{applicationId}/views/{viewId}/activities/importExcel

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| viewId        | 是       | 视图id   |

**权限说明：**

无。

**请求包体：**

```
{
    "impmappingconfigid":"IynOn3U8buOnhRuKEgV",
    "path":"uploads/excel/2017/055ff797.xlsx",
    "actId":"11e7-5f9a-74ef9518-917f-e799edecb417"
}

```

**参数说明：**

| **参数**           | **必须** | **说明**        |
|--------------------|----------|-----------------|
| impmappingconfigid | 是       | Excel导入模板id |
| path               | 是       | 上传文件路径    |
| actId              | 是       | 按钮id          |

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "成功导入.."
}

```

**参数说明：**

| **参数** | **说明**                   |
|----------|----------------------------|
| errcode  | 返回码                     |
| errmsg   | 对返回码的文本描述内容     |
| data     | 导入成功或者失败后返回信息 |

### 打印
----

**请求方式：** GET  
**请求地址：**/api/runtime/{applicationId}/forms/{formId}/documents/{docId}/activities/print

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| formId        | 是       | 表单id   |
| docId         | 是       | 文档id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "document": {
            "id": "value",
            "formid": "value",
            "applicationid": "value",
            "mappingId": "value",
            "stateid": "value",
            "versions": 1,
            "parentid": "value",
            "authorDeptIndex": "value",
            "stateInt": 0,
            "istmp": false,
            "lastmodified": "value",
            "auditdate": "value",
            "created": "value",
            "authorId": "value",
            "initiator": "value",
            "audituser": "value",
            "lastFlowOperation": 80,
            "stateLabelInfo": "value",
            "auditorList": "value",
            "prevAuditNode": "value",
            "prevAuditUser": "value",
            "sign": "value",
            "items": [
                {
                    "name": "value",
                    "age": 0,
                    "date": "2017-6-23"
                }
            ]
        },
        "style": "value",
        "approvers": [
            [
                {
                    "instanceId": "11e7-5c9e-f9e93dfc-b2d6-b959e8a4d585",
                    "flowName": "测试流程",
                    "flowId": "11e6-5fae-abde2740-b3ac-31493634e7af",
                    "nodes": [
                        {
                            "nodeId": "1470911349645",
                            "stateLabel": "节点二[标签]",
                            "auditors": [
                                {
                                    "id": "11e6-6ab3-19bfcfc3-bcfe-1f3c25384deb",
                                    "name": "happy"
                                }
                            ]
                        }
                    ]
                }
            ]
        ],
        "html": "包含表单信息的模板，控件只有占位符标签，不包含控件的数据",
        "fields": [
        {
            "fieldtype": "VALUE_TYPE_VARCHAR",
            "hiddenValue": "",
            "borderType": false,
            "numberPattern": "",
            "discript": "",
            "id": "11e7-61ee-2453c635-991c-c72710268258_单行文本_名称",
            "displayType": 2,
            "name": "单行文本_名称",
            "readOnlyShowValOnly": true,
            "value": "",
            "cssClass": "input-cmd",
            "fieldkeyevent": "Tabkey",
            "textType": "text",
            "refreshOnChanged": false,
            "layoutType": "horizontal"
        }]
    }
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回的表单对象，数据结构参考[\#3.3](#获取pdf文件) |

### 运算地址脚本
------------

**请求方式：** GET  
**请求地址：**/api/runtime/{applicationId}/activities/{actId}/executeAddress?docId={docId}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| actId         | 是       | 按钮id   |
| docId         | 否       | 文档id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "content": "http://localhost:80/portal/dynaform/view/displayViewWithPermission.action?_viewid=11e7-687c-c592e0b0-8a83-bf38d96990bd&clearTemp=true&application=11e7-5f98-d7d66840-917f-e799edecb417&_backURL=../../../portal/H5/closeTab.jsp",
        "type": 16
    }
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| content  | 运算后返回数据         |
| type     | 类型                   |

### 记录操作日志
------------

**请求方式：** POST  
**请求地址：**/api/runtime/activities/recordHandleLog?formId={formId}&viewId={viewId}&actType={actType}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| formId | 否       | 表单id   |
| viewId         | 否       | 视图id   |
| actType         | 是       | 操作类型   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |


## 7. **菜单（Menus）**

###  获取菜单

>   获取登陆用户有权限打开的菜单列表。

**请求方式：** GET  
**请求地址：**/api/runtime/{applicationId}/menus?isMobile={isMobile}

**路径参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| isMobile | 否       | 是否移动端   |

**权限说明：**

无。

**返回结果：**

```
{
"errcode":0,
"errmsg":"ok",
"data":[]
}

```

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 可用的菜单列表         |

### 菜单数据结构说明
----------------

**菜单对象（Menu）数据结构：**

```
{
    "id":"11e7-65fd-02880838-8f1a-bfe936d3ae2a",
    "name":"选项基表",
    "applicationid":"11e7-5f98-d7d66840-917f-e799edecb417",
    "description":"选项基表",
    "type":"00",
    "opentarget":"detail",
    "ico":"{\"icon\":\"/portal/H5/resource/images/icon_menu_default.png\",\"icontype\":\"img\"}",
    "superior":"11e7-676e-f945e3ed-9f81-63911c9fa2cf",
    "linkName":"选项基表",
    "linkType":"01",
    "moduleid":"11e7-6167-730d0ba3-991c-c72710268258",
    "directory":"portal",
    "actionContent":"11e7-65fc-33a47841-8f1a-bfe936d3ae2a",
    "queryString":"[]",
    "permissionType":"public",
    "showType":0,
    "orderno":0,
    "htmlTerminal":true,
    "mobileTerminal":true
}

```

**参数说明：**

| **参数**       | **数据类型** | **说明**                          |
|----------------|--------------|-----------------------------------|
| id             | String       | 主键，菜单对象的唯一标识          |
| name           | String       | 菜单名字                          |
| applicationid  | String       | 软件id                            |
| description    | String       | 菜单描述                          |
| type           | String       | 映射到物理表（TLK_XXX）对应数据id |
| opentarget     | String       | 打开链接                          |
| ico            | String       | 图标                              |
| superior       | Integer      | 流程处理状态标识                  |
| linkName       | String       | 链接名称                          |
| linkType       | String       | 链接类型                          |
| moduleid       | String       | 所属模块                          |
| directory      | String       | 链接内容指定的目录                |
| actionContent  | String       | 链接内容                          |
| queryString    | String       | 请求参数                          |
| permissionType | String       | 授权方式                          |
| showType       | Integer      | 菜单显示方式                      |
| orderNo        | Integer      | 排序号                            |
| htmlTerminal   | Boolean      | 判断是否pc端菜单                  |
| mobileTerminal | Boolean      | 判断是否移动端菜单                |

## 8.  **流程中心（FlowCenters）**

###  获取发起菜单

>   服务器返回发起表单的结果。

**请求方式：** GET  
**请求地址：**/api/runtime/{applicationId}/flowcenters/startmenus?isUsual={isUsual}&isMobile={isMobile}&isUsualList={isUsualList}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| isUsual | 否       | 是否常用菜单   |
| isMobile | 否       | 是否移动端   |
| isUsualList | 否       | 是否常用添加列表   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [{
    "id"："id",
    "url"："url",
    "description"："请假申请",
    "parent"："parentid",
    "level"："1",
    "ico"：{
                    "icon": "/portal/H5/resource/images/icon_menu_default.png",
                    "icontype": "img"
                }
    }]
}

```

**参数说明：**

| **参数**            | **说明**               |
|---------------------|------------------------|
| errcode             | 返回码                 |
| errmsg              | 对返回码的文本描述内容 |
| data[0].id          | 菜单id                 |
| data[0].url         | 打开表单的地址         |
| data[0].parent      | 父菜单id               |
| data[0].level       | 菜单级别               |
| data[0].ico         | 图标                   |
| data[0].description | 描述                   |

###  添加常用发起菜单

>   服务器返回新建成功信息。

**请求方式：** POST  
**请求地址：**/api/runtime/{applicationId}/flowcenters/startMenus/{id}/usual

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| id | 是    | 发起菜单id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "成功"
}

```

**参数说明：**

| **参数**            | **说明**               |
|---------------------|------------------------|
| errcode             | 返回码                 |
| errmsg              | 对返回码的文本描述内容 |
| data          |新建成功信息                |

###  更新常用发起菜单(使用次数)

>   服务器返回更新成功信息。

**请求方式：** PUT  
**请求地址：**/api/runtime/{applicationId}/flowcenters/startMenus/{id}/usual

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| id | 是    | 发起菜单id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "成功"
}

```

**参数说明：**

| **参数**            | **说明**               |
|---------------------|------------------------|
| errcode             | 返回码                 |
| errmsg              | 对返回码的文本描述内容 |
| data          |更新成功信息                |

###  移除常用发起菜单

>   服务器返回删除成功信息。

**请求方式：** DELETE  
**请求地址：**/api/runtime/{applicationId}/flowcenters/startMenus/{id}/usual

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| id | 是    | 发起菜单id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "成功"
}

```

**参数说明：**

| **参数**            | **说明**               |
|---------------------|------------------------|
| errcode             | 返回码                 |
| errmsg              | 对返回码的文本描述内容 |
| data          |删除成功信息                |

### 获取软件列表
------------

>   服务器返回发起表单软件的结果。

**请求方式：** GET  
**请求地址：**/api/runtime/flowcenters/applications

**参数说明：**

| **参数** | **必须** | **说明** |
|----------|----------|----------|


**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [{
    "id":"11de-f053-df18d577-aeb6-19a7865cfdb6",
    "name":"行政办公"}]
}

```

**参数说明：**

| **参数**     | **说明**               |
|--------------|------------------------|
| errcode      | 返回码                 |
| errmsg       | 对返回码的文本描述内容 |
| data[0].id   | 软件id                 |
| data[0].name | 软件名称               |

### 获取待办导航
------------

>   服务器返回代办导航的结果。

**请求方式：** GET  
**请求地址：**/api/runtime/flowcenters/navs/pendings?applicationId={applicationId}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 否       | 软件id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
    {
        "id": "11e7-5f98-d7d66840-917f-e799edecb417",
        "pendingFlowList": [
            {
                "id": "freeFlow",
                "num": 1,
                "name": "流程基本信息_名称"
            },
            {
                "id": "11e7-64a2-865adaa0-9cdb-af6bc8266ed2",
                "num": 3,
                "name": "列表视图_case001"
            },
            {
                "id": "",
                "num": 33,
                "name": "全部"
            }
        ],
        "name": "自动化测试系统"
    }
]
}

```

**参数说明：**

| **参数**                | **说明**               |
|-------------------------|------------------------|
| errcode                 | 返回码                 |
| errmsg                  | 对返回码的文本描述内容 |
| id                      | 软件id                 |
| name                    | 软件名称               |
| pendingFlowList         | 代办列表集合           |
| pendingFlowList[0].id   | 流程id                 |
| pendingFlowList[0].name | 表单名称               |
| pendingFlowList[0].num  | 流程数量               |

### 获取经办导航
------------

>   服务器返回经办导航的结果。

**请求方式：** GET  
**请求地址：**/api/runtime/flowcenters/navs/processeds?applicationId={applicationId}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 否       | 软件id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
    {
        "id": "11e7-5f98-d7d66840-917f-e799edecb417",
        "name": "自动化测试系统",
        "processedFlowList": [
            {
                "id": "freeFlow",
                "num": 4,
                "name": "流程基本信息_名称"
            },
            {
                "id": "freeFlow",
                "num": 2,
                "name": "设计时分秒"
            },
            {
                "id": "",
                "num": 69,
                "name": "全部"
            }
        ]
    }
]
}

```

**参数说明：**

| **参数**                | **说明**               |
|-------------------------|------------------------|
| errcode                 | 返回码                 |
| errmsg                  | 对返回码的文本描述内容 |
| id                      | 软件id                 |
| name                    | 软件名臣               |
| pendingFlowList         | 代办列表集合           |
| pendingFlowList[0].id   | 流程id                 |
| pendingFlowList[0].name | 表单名称               |
| pendingFlowList[0].num  | 流程数量               |

### 获取抄送导航

------

> 服务器返回抄送导航的结果。

**请求方式：** GET  
**请求地址：**/api/runtime/flowcenters/navs/carboncopy?applicationId={applicationId}

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 否       | 软件id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
    {
        "id": "11e7-5f98-d7d66840-917f-e799edecb417",
        "name": "自动化测试系统",
        "processedFlowList": [
            {
                "id": "freeFlow",
                "num": 4,
                "name": "流程基本信息_名称"
            },
            {
                "id": "freeFlow",
                "num": 2,
                "name": "设计时分秒"
            },
            {
                "id": "",
                "num": 69,
                "name": "全部"
            }
        ]
    }
]
}

```

**参数说明：**

| **参数**                | **说明**               |
| ----------------------- | ---------------------- |
| errcode                 | 返回码                 |
| errmsg                  | 对返回码的文本描述内容 |
| id                      | 软件id                 |
| name                    | 软件名臣               |
| pendingFlowList         | 代办列表集合           |
| pendingFlowList[0].id   | 流程id                 |
| pendingFlowList[0].name | 表单名称               |
| pendingFlowList[0].num  | 流程数量               |

### 获取待办事项

------------

>   服务器返回盗版事项的结果。

**请求方式：** GET  
**请求地址：**/api/runtime/{applicationId}/flowcenters/pendings?title={title}&flowId={flowId}&initiatorId={initiatorId}&pageNo={pageNo}&linesPerPage={linesPerPage}&isMobile={isMobile}

**参数说明：**

| **参数**      | **必须** | **说明**     |
|---------------|----------|--------------|
| applicationId | 是       | 软件id       |
| title         | 否       | 主题内容     |
| flowId        | 否       | 流程id       |
| initiatorId   | 否       | 发起人id     |
| pageNo        | 否       | 当前页       |
| linesPerPage  | 否       | 每页显示条数 |
| isMobile  | 否       | 是否移动端 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
    "datas": [
        {
            "applicationId": "11e7-5f98-d7d66840-917f-e799edecb417",
            "auditorList": [{\"instanceId\":\"cASVnFsg2mJ3BHZFHE9\",\"flowName\":\"基本信息_允许审批人终止流程\",\"flowId\":\"11e7-677e-ac9203c7-bb6a-ff15ffadffa1\",\"nodes\":[{\"nodeId\":\"1499778203280\",\"stateLabel\":\"起草\",\"auditors\":[{\"id\":\"11e7-5f9a-210f9112-917f-e799edecb417\",\"name\":\"李玲\"}]}]}],
            "auditorNames": "李玲",
            "docId": "A5ZdTitYLFno5EExk3H",
            "firstProcessTime": "2017-11-01T17:39:28",
            "flowId": "11e7-677e-ac9203c7-bb6a-ff15ffadffa1",
            "flowName": "基本信息_允许审批人终止流程",
            "formId": "11e7-677f-c922602d-bb6a-ff15ffadffa1",
            "initiator": "李玲",
            "initiatorDept": "自动化测试组",
            "initiatorDeptId": "11e7-5f9a-0020047a-917f-e799edecb417",
            "initiatorId": "11e7-5f9a-210f9112-917f-e799edecb417",
            "lastFlowOperation": "1",
            "lastProcessTime": "2017-11-01T17:39:28",
            "read": true,
            "stateLabel": "起草",
            "subject": ""
        }
    ],
    "linesPerPage": 10,
    "pageCount": 4,
    "pageNo": 1,
    "rowCount": 33
}
}

```

**参数说明：**

| **参数**                   | **说明**               |
|----------------------------|------------------------|
| errcode                    | 返回码                 |
| errmsg                     | 对返回码的文本描述内容 |
| datas                      | 待办列表集合           |
| datas[0].applicationId     | 软件id                 |
| datas[0].auditorList       | 处理人列表             |
| datas[0].auditorNames      | 处理人名称             |
| datas[0].docId             | 文档id                 |
| datas[0].formId            | 表单id                 |
| datas[0].firstProcessTime  | 第一处理时间           |
| datas[0].lastProcessTime   | 最后处理时间           |
| datas[0].flowId            | 流程id                 |
| datas[0].flowName          | 流程名称               |
| datas[0].initiatorId       | 发起人id               |
| datas[0].initiator         | 发起人                 |
| datas[0].initiatorDeptId   | 发起人部门id           |
| datas[0].initiatorDept     | 发起人部门             |
| datas[0].lastFlowOperation | 最后处理动作           |
| datas[0].read              | 是否已读               |
| datas[0].stateLabel        | 状态描述               |
| datas[0].subject           | 主题                   |
| linesPerPage               | 每页显示数据条数       |
| pageCount                  | 总页数                 |
| pageNo                     | 当前页                 |
| rowCount                   | 总条数                 |

### 获取经办事项
------------

>   服务器返回经办事项的结果。

**请求方式：** GET  
**请求地址：**/api/runtime/{applicationId}/flowcenters/processeds?title={title}&flowId={flowId}&initiatorId={initiatorId}&status={status}&isMyWorkFlow={isMyWorkFlow}&pageNo={pageNo}&linesPerPage={linesPerPage}

**参数说明：**

| **参数**      | **必须** | **说明**       |
| ------------- | -------- | -------------- |
| applicationId | 是       | 软件id         |
| title         | 否       | 主题内容       |
| flowId        | 否       | 流程id         |
| initiatorId   | 否       | 发起人id       |
| status        | 否       | 完成状态       |
| isMyWorkFlow  | 否       | 是否是我处理的 |
| pageNo        | 否       | 当前页         |
| linesPerPage  | 否       | 每页显示条数   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
    "datas": [
        {
            "applicationId": "11e7-5f98-d7d66840-917f-e799edecb417",
            "auditorList": [{\"instanceId\":\"kpXmp8VDO8kqRh6QqO6\",\"flowName\":\"基本信息_允许审批人终止流程\",\"flowId\":\"11e7-677e-ac9203c7-bb6a-ff15ffadffa1\",\"nodes\":[{\"nodeId\":\"11e7-5f9a-cc4b2b49-917f-e799edecb417\",\"stateLabel\":\"张强\",\"auditors\":[{\"id\":\"11e7-5f9a-cc4b2b49-917f-e799edecb417\",\"name\":\"张强\"}]}]}],
            "auditorNames": "张强",
            "docId": "X4tcUzit3MiRuosmWIc",
            "firstProcessTime": "2017-11-01T17:36:44",
            "flowId": "11e7-677e-ac9203c7-bb6a-ff15ffadffa1",
            "flowName": "基本信息_允许审批人终止流程",
            "formId": "11e7-677f-c922602d-bb6a-ff15ffadffa1",
            "initiator": "李玲",
            "initiatorDept": "自动化测试组",
            "initiatorDeptId": "11e7-5f9a-0020047a-917f-e799edecb417",
            "initiatorId": "11e7-5f9a-210f9112-917f-e799edecb417",
            "lastFlowOperation": "80",
            "lastProcessTime": "2017-11-01T17:39:15",
            "stateLabel": "张强",
            "subject": ""
        }
    ],
    "linesPerPage": 10,
    "pageCount": 7,
    "pageNo": 1,
    "rowCount": 69
}
}

```

**参数说明：**

| **参数**                   | **说明**               |
|----------------------------|------------------------|
| errcode                    | 返回码                 |
| errmsg                     | 对返回码的文本描述内容 |
| datas                      | 经办列表集合           |
| datas[0].applicationId     | 软件id                 |
| datas[0].auditorList       | 处理人列表             |
| datas[0].auditorNames      | 处理人名称             |
| datas[0].docId             | 文档id                 |
| datas[0].formId            | 表单id                 |
| datas[0].firstProcessTime  | 第一处理时间           |
| datas[0].lastProcessTime   | 最后处理时间           |
| datas[0].flowId            | 流程id                 |
| datas[0].flowName          | 流程名称               |
| datas[0].initiatorId       | 发起人id               |
| datas[0].initiator         | 发起人                 |
| datas[0].initiatorDeptId   | 发起人部门id           |
| datas[0].initiatorDept     | 发起人部门             |
| datas[0].lastFlowOperation | 最后处理动作           |
| datas[0].stateLabel        | 状态描述               |
| datas[0].subject           | 主题                   |
| linesPerPage               | 每页显示数据条数       |
| pageCount                  | 总页数                 |
| pageNo                     | 当前页                 |
| rowCount                   | 总条数                 |

### 获取抄送事项

------

> 服务器返回抄送事项的结果。

**请求方式：** GET  
**请求地址：**/api/runtime/{applicationId}/flowcenters/carboncopy?title={title}&flowId={flowId}&initiatorId={initiatorId}&isRead={isRead}&isMyWorkFlow={isMyWorkFlow}&pageNo={pageNo}&linesPerPage={linesPerPage}

**参数说明：**

| **参数**      | **必须** | **说明**       |
| ------------- | -------- | -------------- |
| applicationId | 是       | 软件id         |
| title         | 否       | 主题内容       |
| flowId        | 否       | 流程id         |
| initiatorId   | 否       | 发起人id       |
| isRead        | 是       | 是否已读       |
| isMyWorkFlow  | 否       | 是否是我处理的 |
| pageNo        | 否       | 当前页         |
| linesPerPage  | 否       | 每页显示条数   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
    "datas": [
        {
            "applicationId": "11e7-5f98-d7d66840-917f-e799edecb417",
            "auditorList": [{\"instanceId\":\"kpXmp8VDO8kqRh6QqO6\",\"flowName\":\"基本信息_允许审批人终止流程\",\"flowId\":\"11e7-677e-ac9203c7-bb6a-ff15ffadffa1\",\"nodes\":[{\"nodeId\":\"11e7-5f9a-cc4b2b49-917f-e799edecb417\",\"stateLabel\":\"张强\",\"auditors\":[{\"id\":\"11e7-5f9a-cc4b2b49-917f-e799edecb417\",\"name\":\"张强\"}]}]}],
            "auditorNames": "张强",
            "docId": "X4tcUzit3MiRuosmWIc",
            "firstProcessTime": "2017-11-01T17:36:44",
            "flowId": "11e7-677e-ac9203c7-bb6a-ff15ffadffa1",
            "flowName": "基本信息_允许审批人终止流程",
            "formId": "11e7-677f-c922602d-bb6a-ff15ffadffa1",
            "initiator": "李玲",
            "initiatorDept": "自动化测试组",
            "initiatorDeptId": "11e7-5f9a-0020047a-917f-e799edecb417",
            "initiatorId": "11e7-5f9a-210f9112-917f-e799edecb417",
            "lastFlowOperation": "80",
            "lastProcessTime": "2017-11-01T17:39:15",
            "stateLabel": "张强",
            "subject": ""
        }
    ],
    "linesPerPage": 10,
    "pageCount": 7,
    "pageNo": 1,
    "rowCount": 69
}
}

```

**参数说明：**

| **参数**                   | **说明**               |
| -------------------------- | ---------------------- |
| errcode                    | 返回码                 |
| errmsg                     | 对返回码的文本描述内容 |
| datas                      | 经办列表集合           |
| datas[0].applicationId     | 软件id                 |
| datas[0].auditorList       | 处理人列表             |
| datas[0].auditorNames      | 处理人名称             |
| datas[0].docId             | 文档id                 |
| datas[0].formId            | 表单id                 |
| datas[0].firstProcessTime  | 第一处理时间           |
| datas[0].lastProcessTime   | 最后处理时间           |
| datas[0].flowId            | 流程id                 |
| datas[0].flowName          | 流程名称               |
| datas[0].initiatorId       | 发起人id               |
| datas[0].initiator         | 发起人                 |
| datas[0].initiatorDeptId   | 发起人部门id           |
| datas[0].initiatorDept     | 发起人部门             |
| datas[0].lastFlowOperation | 最后处理动作           |
| datas[0].stateLabel        | 状态描述               |
| datas[0].subject           | 主题                   |
| linesPerPage               | 每页显示数据条数       |
| pageCount                  | 总页数                 |
| pageNo                     | 当前页                 |
| rowCount                   | 总条数                 |

### 经办标记全部已读

------

> 经办标记全部已读。

**请求方式：** GET  
**请求地址：**/api/runtime/flowcenters/pendings/allRead

**参数说明：**

**权限说明：**

无。

**返回结果：**

```
{"errcode":0,"errmsg":"ok","data":"success"}
```

**参数说明：**

| **参数** | **说明**               |
| -------- | ---------------------- |
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |

## 9. **小工具 （Widgets）**

###  获取用户首页设置

**请求方式：** GET  
**请求地址：**/api/runtime/homepage/config

**参数说明：**

| **参数** | **必须** | **说明** |
|----------|----------|----------|


**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "widgets": {
            "11e7-679f-970641fb-bb6a-ff15ffadffa1": {
                "icontype": null,
                "titleBColor": "",
                "titleColor": "#000",
                "iconShow": false,
                "icon": {
                    "icontype": "font",
                    "icon": "if-lib icon-xinwenxinxi",
                    "iconFontColor": "#000"
                },
                "description": null,
                "id": "11e7-679f-970641fb-bb6a-ff15ffadffa1",
                "applicationId": "11e7-5f98-d7d66840-917f-e799edecb417",
                "type": "summary",
                "height": ""
            }
        },
        "setting": {
            "appM": [
                "11e7-6c4a-66734702-966a-876161d2b77c",
                "system_knowledge"
            ],
            "appIcon": [
                "11e7-67cb-ab88f1ac-bb6a-ff15ffadffa1",
                "11e7-67cc-0304449e-bb6a-ff15ffadffa1"
            ],
            "appL": [
                "11e7-67a0-f2fd635a-bb6a-ff15ffadffa1",
                "system_empconbook"
            ],
            "layoutStyle": "1:1:1",
            "appR": []
        }
    }
}

```

**参数说明：**

| **参数** | **说明**                                                                                                                                          |
|----------|---------------------------------------------------------------------------------------------------------------------------------------------------|
| errcode  | 返回码                                                                                                                                            |
| errmsg   | 对返回码的文本描述内容                                                                                                                            |
| data     | 返回的表单对象，数据结构参考[\#3.3](file:///D:\Document\IntelliJ\obpm_dev\docs\设计文档\myApps运行时RESTful%20API说明文档.docx#_表单数据结构说明) |


### 保存用户首页设置
-----------------

**请求方式：** POST  
**请求地址：**/api/runtime/homepage/config

请求包体：

```
{
    "appM": [
        "11e7-6c4a-66734702-966a-876161d2b77c",
        "11e7-6c4a-54176aed-966a-876161d2b77c"
    ],
    "appIcon": [
        "11e7-67cb-ab88f1ac-bb6a-ff15ffadffa1",
        "11e7-67cb-701bedca-bb6a-ff15ffadffa1"
    ],
    "appL": [
        "11e7-67a0-f2fd635a-bb6a-ff15ffadffa1",
        "system_empconbook"
    ],
    "layoutStyle": "1:1:1",
    "appR": []
}

```

**参数说明：**

| **参数** | **必须** | **说明** |
|----------|----------|----------|


**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                                                                                                                                          |
|----------|---------------------------------------------------------------------------------------------------------------------------------------------------|
| errcode  | 返回码                                                                                                                                            |
| errmsg   | 对返回码的文本描述内容                                                                                                                            |
| data     | 返回的表单对象，数据结构参考[\#3.3](file:///D:\Document\IntelliJ\obpm_dev\docs\设计文档\myApps运行时RESTful%20API说明文档.docx#_表单数据结构说明) |

###  获取指定widget内容
-------------------

**请求方式：** GET  
**请求地址：**/api/runtime/widgets/WIDGETID

**参数说明：**

| **参数** | **必须** | **说明**   |
|----------|----------|------------|
| WIDGETID | 是       | wideget id |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {} //不同widget，返回的数据格式不同
}

```

**参数说明：**

| **参数** | **说明**                                                                                                                                          |
|----------|---------------------------------------------------------------------------------------------------------------------------------------------------|
| errcode  | 返回码                                                                                                                                            |
| errmsg   | 对返回码的文本描述内容                                                                                                                            |
| data     | 返回的表单对象，数据结构参考[\#3.3](file:///D:\Document\IntelliJ\obpm_dev\docs\设计文档\myApps运行时RESTful%20API说明文档.docx#_表单数据结构说明) |

### 获取widget(我的待办)
--------------------

**请求方式：** GET  
**请求地址：**/api/runtime/ widget/myPending

**参数说明：**

| **参数**     | **必须** | **说明** |
|--------------|----------|----------|
| pageNo       | 是       | 整数     |
| linesPerPage | 是       | 整数     |

**权限说明：**

用户所拥有软件的待办(每个软件拿取最新的待办linesPerPage的条数，然后进行时间排序的合并，拿取最前的linesPerPage条数，返回包体给前台)

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 22,
        "linesPerPage": 2,
        "pageNo": 1,
        "datas": [{
            "applicationId": "VFwDvnIIvpDmwrPJ63s",
            "docId": "3d2tRitdjBeuoOb2W2y",
            "formId": "wTqxMMVbL9s1Ud4ikfq",
            "flowId": "aSXR0LQ5d8nbXhehyBP",
            "flowName": "lc1",
            "stateLabel": "2",
            "auditorNames": "oliver2,oliver3",
            "auditorList": "[...]",
            "subject": "QWERTY    mb1/bd1    ",
            "initiator": "oliver",
            "initiatorId": "cgOB9f2NXQyzuefSmKC",
            "initiatorDept": "客户服务部",
            "initiatorDeptId": "11e5-8ea0-79d39897-b6a8-8959966cbe66",
            "firstProcessTime": "2018-03-19 18:37:52",
            "lastProcessTime": "2018-03-19 18:37:53",
            "lastFlowOperation": "80",
            "read": false
        }, {
            "applicationId": "VFwDvnIIvpDmwrPJ63s",
            "docId": "1izKwOXqnQvd0WbIKyM",
            "formId": "wTqxMMVbL9s1Ud4ikfq",
            "flowId": "aSXR0LQ5d8nbXhehyBP",
            "flowName": "lc1",
            "stateLabel": "2",
            "auditorNames": "oliver2,oliver3",
            "auditorList": "[...]",
            "subject": "",
            "initiator": "oliver",
            "initiatorId": "cgOB9f2NXQyzuefSmKC",
            "initiatorDept": "客户服务部",
            "initiatorDeptId": "11e5-8ea0-79d39897-b6a8-8959966cbe66",
            "firstProcessTime": "2018-03-19 15:45:29",
            "lastProcessTime": "2018-03-19 15:45:29",
            "lastFlowOperation": "80",
            "read": false
        }],
        "pageCount": 11
    }
}

```

**参数说明：**

| **参数** | **说明**                                                                                                                                          |
|----------|---------------------------------------------------------------------------------------------------------------------------------------------------|
| errcode  | 返回码                                                                                                                                            |
| errmsg   | 对返回码的文本描述内容                                                                                                                            |
| data     | 返回的表单对象，数据结构参考[\#3.3](file:///D:\Document\IntelliJ\obpm_dev\docs\设计文档\myApps运行时RESTful%20API说明文档.docx#_表单数据结构说明) |

### 获取widget(我的已办)
--------------------

**请求方式：** GET  
**请求地址：**/api/runtime/ widget/ myProcessing

**参数说明：**

| **参数**     | **必须** | **说明** |
|--------------|----------|----------|
| pageNo       | 是       | 整数     |
| linesPerPage | 是       | 整数     |

**权限说明：**

用户所拥有软件的已办(每个软件拿取最新的已办linesPerPage的条数，然后进行时间排序的合并，拿取最前的linesPerPage条数，返回包体给前台)

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 15,
        "linesPerPage": 2,
        "pageNo": 1,
        "datas": [{
            "applicationId": "11e6-429d-dd7a3284-86a2-074015f7cc96",
            "docId": "FlEBA0NuTpVyWXUwpsZ",
            "formId": "O3sGG1gOo1FXPgVXcjn",
            "flowId": "rLPRrUTfTm7lSRwLqT3",
            "flowName": "流程1",
            "stateLabel": "2",
            "auditorNames": "...",
            "auditorList": "[...]",
            "subject": "",
            "initiator": "oliver2",
            "initiatorId": "zDdCgz9OiPj4hfjfLhR",
            "initiatorDept": "项目部",
            "initiatorDeptId": "11e6-292f-51466c29-9a78-9b801f3f5251",
            "firstProcessTime": "2018-02-27 17:59:28",
            "lastProcessTime": "2018-02-27 17:59:29",
            "lastFlowOperation": "80",
            "read": null
        }, {
            "applicationId": "11e6-429d-dd7a3284-86a2-074015f7cc96",
            "docId": "hCW0aTPDIsDDN6iT34E",
            "formId": "KKn4dCrk67Pw3rw6tud",
            "flowId": "uiFFzqbxenvVwS5D3tP",
            "flowName": "新建测试流程2",
            "stateLabel": "2",
            "auditorNames": "管理员,karrman,we,钟总经理（总经理）",
            "auditorList": "[...]",
            "subject": "",
            "initiator": "oliver2",
            "initiatorId": "zDdCgz9OiPj4hfjfLhR",
            "initiatorDept": "项目部",
            "initiatorDeptId": "11e6-292f-51466c29-9a78-9b801f3f5251",
            "firstProcessTime": "2018-02-24 10:12:47",
            "lastProcessTime": "2018-02-24 10:12:48",
            "lastFlowOperation": "80",
            "read": null
        }],
        "pageCount": 8
    }
}

```

**参数说明：**

| **参数** | **说明**                                                                                                                                          |
|----------|---------------------------------------------------------------------------------------------------------------------------------------------------|
| errcode  | 返回码                                                                                                                                            |
| errmsg   | 对返回码的文本描述内容                                                                                                                            |
| data     | 返回的表单对象，数据结构参考[\#3.3](file:///D:\Document\IntelliJ\obpm_dev\docs\设计文档\myApps运行时RESTful%20API说明文档.docx#_表单数据结构说明) |

### 获取widget(我的抄送)
--------------------

**请求方式：** GET  
**请求地址：**/api/runtime/ widget/ myCopy

**参数说明：**

| **参数**     | **必须** | **说明** |
|--------------|----------|----------|
| pageNo       | 是       | 整数     |
| linesPerPage | 是       | 整数     |

**权限说明：**

用户所拥有软件的抄送(每个软件拿取最新的抄送linesPerPage的条数，然后进行时间排序的合并，拿取最前的linesPerPage条数，返回包体给前台)

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 4,
        "linesPerPage": 2,
        "pageNo": 1,
        "datas": [{
            "id": "F3GWGBzFRzixcQRpc36",
            "name": "oliver2",
            "userId": "zDdCgz9OiPj4hfjfLhR",
            "docId": "3d2tRitdjBeuoOb2W2y",
            "nodertId": "jPi3oyWDUtfmbgDKjhE",
            "flowstatertId": "LD28oTtpstrtbWxim93",
            "ccTime": 1521455872000,
            "readTime": null,
            "deadline": null,
            "read": false,
            "summary": "QWERTY    mb1/bd1    ",
            "formId": "wTqxMMVbL9s1Ud4ikfq"
        }, {
            "id": "cI009I7C3Yjin54oT85",
            "name": "oliver2",
            "userId": "zDdCgz9OiPj4hfjfLhR",
            "docId": "1izKwOXqnQvd0WbIKyM",
            "nodertId": "3cTJN94Frgq497C0hjg",
            "flowstatertId": "LxWIw9EIhKcaQFf5EV4",
            "ccTime": 1521445529000,
            "readTime": null,
            "deadline": null,
            "read": false,
            "summary": "QW",
            "formId": "wTqxMMVbL9s1Ud4ikfq"
        }],
        "pageCount": 2
    }
}

```

**参数说明：**

| **参数** | **说明**                                                                                                                                          |
|----------|---------------------------------------------------------------------------------------------------------------------------------------------------|
| errcode  | 返回码                                                                                                                                            |
| errmsg   | 对返回码的文本描述内容                                                                                                                            |
| data     | 返回的表单对象，数据结构参考[\#3.3](file:///D:\Document\IntelliJ\obpm_dev\docs\设计文档\myApps运行时RESTful%20API说明文档.docx#_表单数据结构说明) |

### 签到

--------------------

**请求方式：** POST  
**请求地址：**/api/runtime/{applicationId}/widgets/{widgetId}/checkin

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| widgetId      | 是       | widgetid |

**权限说明：**

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "wQJ1AcOOLhT2gXH9VBJ",
        "widgetId": "xsadsacfvtrb",
        "userId": "Fyerrqyr53YShQ8KRya",
        "userName": "超级管理员",
        "checkinTime": 1632044956249
    }
}
```

**参数说明：**

| **参数**         | **说明**               |
| ---------------- | ---------------------- |
| errcode          | 返回码                 |
| errmsg           | 对返回码的文本描述内容 |
| data             | 签到信息               |
| data.id          | 主键                   |
| data.widgetId    | widget主键             |
| data.userId      | 用户主键               |
| data.userName    | 用户名称               |
| data.checkinTime | 签到时间               |

### 是否签到

--------------------

**请求方式：** GET  
**请求地址：**/api/runtime/{applicationId}/widgets/{widgetId}/checkin

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| widgetId      | 是       | widgetid |

**权限说明：**

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": true
}
```

**参数说明：**

| **参数** | **说明**                |
| -------- | ----------------------- |
| errcode  | 返回码                  |
| errmsg   | 对返回码的文本描述内容  |
| data     | 是否签到（true\|false） |

### 签到统计

--------------------

**请求方式：** GET  
**请求地址：**/api/runtime/{applicationId}/widgets/{widgetId}/checkins?countType={countType}

**参数说明：**

| **参数**      | **必须** | **说明**                                               |
| ------------- | -------- | ------------------------------------------------------ |
| applicationId | 是       | 软件id                                                 |
| widgetId      | 是       | widgetid                                               |
| countType     | 否       | 统计类型,none(无),month(月份),quarter(季度),year(年份) |

**权限说明：**

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": 5
}
```

**参数说明：**

| **参数** | **说明**               |
| -------- | ---------------------- |
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 签到次数               |

## 10 **自定义报表（CustomReports）**

### 获取自定义报表数据

>   服务器返回自定义报表数据的结果。

**请求方式：** GET  
**请求地址：**/api/runtime/customreports/{id}

**参数说明：**

| **参数** | **必须** | **说明**                                  |
|----------|----------|-------------------------------------------|
| id       | 是       | 自定义报表id（对应widget中actionContent） |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "xAxis": [
            "666",
            "777",
            "888",
            "999"
        ],
        "yAxis": [
            "21312.00",
            "777.00",
            "888.00",
            "999.00"
        ],
        "sign": "histogram",
        "name": "自定义报表"
    }
}

```

**参数说明：**

| **参数** | **说明**                             |
|----------|--------------------------------------|
| errcode  | 返回码                               |
| errmsg   | 对返回码的文本描述内容               |
| sign     | 报表类型（不同类型返回数据结构不同） |

## 11 **交叉报表（CrossReports）**
###  获取

>   服务器返回包含表单模板、操作、样式库、数据、权限（数据与权限体现在表单控件的属性）的结果。

**请求方式：** GET  
**请求地址：**/api/runtime/{applicationId}/forms/{formId}/documents/{docId}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| formId        | 是       | 表单id   |
| docid         | 是       | 文档id   |

**权限说明：**

无。

**返回结果：**

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回的表单对象，数据结构参考[\#3.3](#获取pdf文件) |

## 12. 报表模块

### 获取报表显示路径

> 服务器返回报表显示路径的结果。

**请求方式：** POST  
**请求地址：**/api/runtime/report/showjrxml/{id}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| id       | 是       | 报表id   |

**权限说明：**

无。

**请求包体：**

{
​     "appId": ""HdPeBqYwJyFyjHkhZu3"",
​     "xx": "xxx"

}

**返回结果：**

```
<script language="javascript">window.location='/obpm//uploads/reports/__6jYUM404JUCgyDaUrA3.html';</script>

```

### 获取报表的查询表单模板

> 服务器返回报表的查询表单模板的结果。

**请求方式：** GET  
**请求地址：**/api/runtime/report/{id}/searchformtemplate/{applicationId}

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| id            | 是       | 报表id   |
| applicationId | 是       | 软件id   |

**权限说明：**

无。

**返回结果：**

```
{  
  "errcode" : 0,  
  "errmsg" : "ok",
  "data" : {
    " fields": [],
    " document": {},
    " template": ".."
    }
}

```

**参数说明：**

| **参数** | **说明**               |
| -------- | ---------------------- |
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 查询表单数据           |

### 报表导出excel

**请求方式：** POST  
**请求地址：**/api/runtime/report/exportexcel/{id}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| id       | 是       | 报表id   |

**权限说明：**

无。

**返回结果：**

无。

### 获取当前报表册下的报表

**请求方式：** GET
**请求地址：**/api/runtime/report/getReportsInGroup?reportGroupId={reportGroupId}&reportIds={reportIds}

**参数说明：**

| **参数**      | **必须** | **说明**         |
| ------------- | -------- | ---------------- |
| reportGroupId | 否       | 报表册id         |
| reportIds     | 否       | 报表的id,用;分隔 |

**权限说明：**

无。

**返回结果：**

{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"data": {
			"__qjPCp8J2dH7x41vyoZ2": "SQL数据源",
			"__9M30I7ZscGZKSI1qIR2": "视图数据源"
		}
	}
}

## 13.  **用户（Users）**

###  获取以部门为树形结构的用户集合

根据客户端传递的父级部门id参数，服务器返回直属下级部门和用户的集合，以树形结构的方式描述数据。

**请求方式：** GET  
**请求地址：**/api/runtime/{applicationId}/users/selectbox/department?deptId={deptId}

**参数说明：**

| **参数**      | **必须** | **说明**   |
|---------------|----------|------------|
| applicationId | 是       | 软件id     |
| deptId        | 是       | 父级部门id |
| pageNum        | 是       | 当前页 |
| pageSize        | 是       | 每页显示数据数 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "datas": [
            {
            "avatar": "",
            "dept": "自动化测试用例系统企业域",
            "email": "",
            "id": "11e7-661d-31b9954a-8f1a-bfe936d3ae2a",
            "mobile": "13025478965",
            "mobile2": "",
            "name": "伟强",
            "type": 1
        },
        {
            "children": [],
            "id": "11e7-5f99-e70d1a49-917f-e799edecb417",
            "name": "测试部",
            "type": 2
        }
        ],
        "pageCount": 1,
        "rowCount": 2,
        "pageNum": 1,
        "linesPerPage": 5
    }
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| datas     | 部门下用户 |
| pageCount | 总页数                 |
| rowCount  | 总行数                 |
| pageNum   | 当前页                 |
| linesPerPage   | 每页显示条数      |

### 获取以角色为树形结构的用户集合
------------------------------

根据客户端传递的角色id参数，服务器返回该角色下的用户的集合，以树形结构的方式描述数据。

**请求方式：** GET  
**请求地址：**/api/runtime/{applicationId}/users/selectbox/role?roleId={roleId}&pageSize={pageSize}&pageNum={pageNum}&flowId={flowId}&nodeId={nodeId}&docId={docId}&type={type}

**参数说明：**

| **参数**      | **必须** | **说明**                                                     |
| ------------- | -------- | ------------------------------------------------------------ |
| applicationId | 是       | 软件id                                                       |
| roleId        | 是       | 角色id                                                       |
| pageSize      | 是       | 每页显示数据数（传入0时默认显示5条数据）                     |
| pageNum       | 是       | 当前页（传入0时默认显示第一页）                              |
| flowId        | 是       | 流程id                                                       |
| nodeId        | 是       | 节点id(指定抄送传的是当前节点id,指定审批人是下一节点id)      |
| docId         | 是       | 文档id                                                       |
| type          | 是       | 类型(传1是指定下一节点审批人，传2指定抄送人，其他传0或者不传) |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "datas": [
            {
                "id": "11e7-5f9a-595d2be8-917f-e799edecb417",
                "name": "员工",
                "type": 4
            },
            {
                "id": "11e7-6bb9-a4500a1c-a461-afe7c10bb740",
                "name": "总经理",
                "type": 4
            }
        ]
    }
}
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "datas": [
            {
                "id": "11e7-5f9a-210f9112-917f-e799edecb417",
                "name": "李玲",
                "type": 1,
                "mobile": "",
                "mobile2": "",
                "email": "jack@teemlink.com",
                "avatar": null,
                "dept": "自动化测试组",
                "deptId": "11e7-5f9a-0020047a-917f-e799edecb417",
                "loginNo": "liling",
                "domainId": "11e7-5f99-cc5d96f1-917f-e799edecb417"
            }
        ],
        "pageCount": 1,
        "rowCount": 2,
        "pageNum": 1,
        "linesPerPage": 5
    }
}

```

**参数说明：**

| **参数**  | **说明**               |
|-----------|------------------------|
| errcode   | 返回码                 |
| errmsg    | 对返回码的文本描述内容 |
| datas     | 角色下用户集合         |
| pageCount | 总页数                 |
| rowCount  | 总行数                 |
| pageNum   | 当前页                 |
| linesPerPage   | 每页显示条数      |

### 获取通讯录用户集
--------------------------------

服务器返回通讯录下所有用户的集合数据。

**请求方式：** GET  
**请求地址：**/api/runtime/users/selectbox/contacts?contactsId={contactsId}&pageSize={pageSize}&pageNum

**参数说明：**

| **参数**      | **必须** | **说明**     |
|---------------|----------|--------------|
| contactsId      | 否       | 通讯录分组id |
| pageSize      | 否       | 每页显示条数 |
| pageNom       | 否       | 当前页       |

**权限说明：**

无。

**返回结果：**

```
{
        "errcode": 0,
        "errmsg": "ok",
        "data": {
        "datas": [
            {
            "avatar": "",
            "dept": "自动化测试用例系统企业域",
            "email": "",
            "id": "11e7-661d-31b9954a-8f1a-bfe936d3ae2a",
            "mobile": "13025478965",
            "mobile2": "",
            "name": "伟强",
            "type": 1
            } 
        ],
        "pageCount": 1,
        "rowCount": 2,
        "pageNum": 1,
        "linesPerPage": 5
    }
 }

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| datas     | 通讯录下用户集合         |
| pageCount | 总页数                 |
| rowCount  | 总行数                 |
| pageNum   | 当前页                 |
| linesPerPage   | 每页显示条数      |

### 更新在线用户

------

**请求方式：** PUT
**请求地址：**/api/runtime/updateOnlineUsers

**参数说明：**

无。

**权限说明：**

无。

**返回结果：**

```
无。
```

**参数说明：**

无。

### 移除在线用户

------

**请求方式：** DELETE
**请求地址：**/api/runtime/removeOnlineUser

**参数说明：**

无。

**权限说明：**

无。

**返回结果：**

```
无。
```

**参数说明：**

无。

### 获取在线用户集合

----------------

服务器返回通讯录下所有在线用户的集合。

**请求方式：** GET  
**请求地址：**/api/runtime/users/selectbox/onlines?pageNum={pageNum}&pageSize={pageSize}

**参数说明：**

| **参数** | **必须** | **说明**     |
|----------|----------|--------------|
| pageNum  | 否       | 当前页       |
| pageSize | 否       | 每页显示条数 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "datas": [
            {
            "avatar": "",
            "dept": "自动化测试用例系统企业域",
            "email": "",
            "id": "11e7-661d-31b9954a-8f1a-bfe936d3ae2a",
            "mobile": "13025478965",
            "mobile2": "",
            "name": "伟强",
            "type": 1
            } 
        ],
        "pageCount": 1,
        "rowCount": 2,
        "pageNum": 1,
        "linesPerPage": 5
 }
```
**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| datas     | 在线用户用户集合         |
| pageCount | 总页数                 |
| rowCount  | 总行数                 |
| pageNum   | 当前页                 |
| linesPerPage   | 每页显示条数      |

### 获取离职用户集合

--------------------------

服务器返回所有离职用户的集合

**请求方式：**GET

**请求地址：**/api/runtime/users/selectbox/dimissions?pageNum={pageNum}&pageSize={pageSize}&domainId={domainId}

**参数说明：**

| **参数** | **必须** | **说明**     |
| -------- | -------- | ------------ |
| pageNum  | 是       | 当前页       |
| pageSize | 是       | 每页显示条数 |
| domainId | 是       | domainId     |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "datas": [
            {
				"id":"anmilDhBJWtHg2Pn2Fy",
				"name":"啊萍",
				"type":1,
				"orderByNo":0,
				"mobile":null,
				"mobile2":null,
				"email":null,
				"avatar":null,
				"dept":null,
				"deptId":null,
				"loginNo":null,
				"domainId":null,
				"pcmEnable":false,
				"domainAdmin":false,
				"log":false
			}
        ]
 }
```
**参数说明：**

| **参数** | **说明**               |
| -------- | ---------------------- |
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| datas    | 离职用户集合           |

### 模糊查询用户

------------

根据联系人姓名,首字母,电话进行模糊查询，服务器返回用户的集合。

**请求方式：** GET  
**请求地址：**/api/runtime/users/selectbox/search?keyWord={keyWord}&pageNum={pageNum}&pageSize={pageSize}

**参数说明：**

| **参数** | **必须** | **说明**     |
|----------|----------|--------------|
| pageNum  | 否       | 当前页       |
| pageSize | 否       | 每页显示条数 |
| keyWord  | 否       | 关键字       |

**权限说明：**

无。

**返回结果：**

```
{
        "errcode": 0,
        "errmsg": "ok",
        "datas": [
            {
            "avatar": "",
            "dept": "自动化测试用例系统企业域",
            "email": "",
            "id": "11e7-661d-31b9954a-8f1a-bfe936d3ae2a",
            "mobile": "13025478965",
            "mobile2": "",
            "name": "伟强",
            "type": 1
            } 
        ],
        "pageCount": 1,
        "rowCount": 2,
        "pageNum": 1,
        "linesPerPage": 5
 }

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| datas     | 查询用户用户集合         |
| pageCount | 总页数                 |
| rowCount  | 总行数                 |
| pageNum   | 当前页                 |
| linesPerPage   | 每页显示条数      |

### 获取部门树
------------

根据父级获取部门树，服务器返回树的集合。

**请求方式：** GET  
**请求地址：**/api/runtime/users/selectbox/dept-tree?parentId={parentId}

**参数说明：**

| **参数** | **必须** | **说明**     |
|----------|----------|--------------|
| parentId  | 否       | 父级id       |

**权限说明：**

无。

**返回结果：**

```
[
    {
        "id": "bRPb1cTqfbrpHbUvtrr",
        "data": "我的公司",
        "state": "closed",
        "attr": {
            "id": "bRPb1cTqfbrpHbUvtrr",
            "name": "我的公司"
        }
    }
]

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 部门jstree集合 |

### 获取通讯录分组
------------

获取通讯录分组。

**请求方式：** GET  
**请求地址：**/api/runtime/users/selectbox/contacts/group

**参数说明：**

| **参数** | **必须** | **说明**     |
|----------|----------|--------------|

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 0,
        "linesPerPage": 0,
        "pageNo": 0,
        "datas": [
            {
                "id": "1XUQawEPVQ6Qyk5TqEY",
                "name": "分组1",
                "ownerId": "MyTiy4G4bDOq6iALQyr"
            }
        ],
        "pageCount": 0
    }
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| datas     | 通讯录分组集合         |
| pageCount | 总页数                 |
| rowCount  | 总行数                 |
| pageNum   | 当前页                 |
| linesPerPage   | 每页显示条数      |

### 新建通讯录分组
------------

新建通讯录分组

**请求方式：** POST  
**请求地址：**/api/runtime/users/contacts/groups?name={name}

**参数说明：**

| **参数** | **必须** | **说明**     |
|----------|----------|--------------|
|name      |    是    |分组名称      |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
                "id": "1XUQawEPVQ6Qyk5TqEY",
                "name": "分组1",
                "ownerId": "MyTiy4G4bDOq6iALQyr"
        }
    }
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 通讯录分组信息         |

### 保存通讯录分组
------------

保存通讯录分组

**请求方式：** POST  
**请求地址：**/api/runtime/users/contacts/groups/{groupId}?name={name}

**参数说明：**

| **参数** | **必须** | **说明**     |
|----------|----------|--------------|
|groupId   |    是    | 分组id       |
|name      |    是    |分组名称      |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
                "id": "1XUQawEPVQ6Qyk5TqEY",
                "name": "分组1",
                "ownerId": "MyTiy4G4bDOq6iALQyr"
        }
    }
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 通讯录分组信息         |

### 删除通讯录分组
------------

删除通讯录分组

**请求方式：** DELETE  
**请求地址：**/api/runtime/users/contacts/groups/{groupId}

**参数说明：**

| **参数** | **必须** | **说明**     |
|----------|----------|--------------|
|groupId   |     是   | 分组id       |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "删除成功"
    }
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 删除成功         |

### 添加用户到通讯录分组
------------

添加用户到通讯录分组

**请求方式：** POST  
**请求地址：**/api/runtime/users/contacts/groups/{groupId}/users

**参数说明：**

| **参数** | **必须** | **说明**     |
|----------|----------|--------------|
|groupId   |     是   | 分组id       |

**请求包体：**

```
[
    "id1",
    "id2",
    "id3"
]

```

**参数说明：**

| **参数**   | **必须** | **说明**                    |
|------------|----------|-----------------------------|
| userIds   | 是       | 用户id集合          |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "添加成功"
    }
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 添加成功         |

### 移除用户到通讯录分组
------------

移除用户到通讯录分组

**请求方式：** DELETE  
**请求地址：**/api/runtime/users/contacts/groups/{groupId}/users

**参数说明：**

| **参数** | **必须** | **说明**     |
|----------|----------|--------------|
|groupId   |     是   | 分组id       |

**请求包体：**

```
[
    "id1",
    "id2",
    "id3"
]

```

**参数说明：**

| **参数**   | **必须** | **说明**                    |
|------------|----------|-----------------------------|
| userIds   | 是       | 用户id集合          |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "移除成功"
    }
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 移除成功         |

### 用户选择框树形数据结构说明
--------------------------

```
[
        {
            "avatar": "",
            "dept": "自动化测试用例系统企业域",
            "email": "",
            "id": "11e7-661d-31b9954a-8f1a-bfe936d3ae2a",
            "mobile": "13025478965",
            "mobile2": "",
            "name": "伟强",
            "type": 1
        },
        {
            "avatar": "",
            "dept": "自动化测试用例系统企业域",
            "email": "",
            "id": "11e7-6bb9-b3b4ed54-a461-afe7c10bb740",
            "mobile": "13254896547",
            "mobile2": "",
            "name": "总经理",
            "type": 1
        },
        {
            "children": [],
            "id": "11e7-654a-2b182ffe-9cdb-af6bc8266ed2",
            "name": "产品部",
            "type": 2
        },
        {
            "children": [],
            "id": "11e7-5f99-e70d1a49-917f-e799edecb417",
            "name": "测试部",
            "type": 2
        }
    ]

```

**参数说明：**

| **参数** | **数据类型** | **说明**                        |
|----------|--------------|---------------------------------|
| avatar   | String       | 头像                            |
| dept     | String       | 部门名称                        |
| email    | String       | 邮件                            |
| id       | String       | 主键                            |
| mobile   | String       | 手机1                           |
| mobile2  | String       | 手机2                           |
| name     | String       | 名字                            |
| children | String       | 子级                            |
| type     | String       | 类型（1用户,2部门,3软件,4角色） |

###  获取当前登陆用户信息
-----------------

获取登录用户信息

**请求方式：** GET  
**请求地址：**/api/runtime/users/myprofile

**权限说明：**

无。

**返回结果：**

```
{
        "errcode": 0,
        "errmsg": "ok",
        "data": 
        {
            "avatar": "",
            "dept": "自动化测试用例系统企业域",
            "email": "",
            "id": "11e7-661d-31b9954a-8f1a-bfe936d3ae2a",
            "mobile": "13025478965",
            "mobile2": "",
            "name": "伟强",
            "type": 1
        }
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回用户信息 |

###  获取用户信息
-----------------

获取登录用户信息

**请求方式：** GET  
**请求地址：**/api/runtime/users/profile?id={id}

**参数说明：**

| **参数** | **必须** | **说明**     |
|----------|----------|--------------|
|id|是|用户id|

**权限说明：**

无。

**返回结果：**

```
{
        "errcode": 0,
        "errmsg": "ok",
        "data": 
        {
            "avatar": "",
            "dept": "自动化测试用例系统企业域",
            "email": "",
            "id": "11e7-661d-31b9954a-8f1a-bfe936d3ae2a",
            "mobile": "13025478965",
            "mobile2": "",
            "name": "伟强",
            "type": 1
        }
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回用户信息 |

###  获取用户签章列表
-----------------

获取登录用户签章列表

**请求方式：** GET  
**请求地址：**/api/runtime/users/signs

**权限说明：**

无。

**返回结果：**

```
{
        "errcode": 0,
        "errmsg": "ok",
        "data": [
        {
            "id": "iUGOhkCPX2QueqG5iUp",
            "name": "123",
            "password": "0d04ee6e708c0136eb0156ef71251544",
            "img": "iUGOhkCPX2QueqG5iUp.jpg",
            "desc": "123",
            "date": "2018-09-05"
        },
        {
            "id": "XdUeahX5pMWYxjzdUVg",
            "name": "1111",
            "password": "423d853ec9aac368af3a1f6cf2edcb51",
            "img": "XdUeahX5pMWYxjzdUVg.jpg",
            "desc": "3333",
            "date": "2018-09-05"
        },
        {
            "id": "XdUeahX5pMWYxjzdUVg",
            "name": "1111",
            "password": "2d060d2ee17163955e099c5374da93f4",
            "img": "XdUeahX5pMWYxjzdUVg.jpg",
            "desc": "3333",
            "date": "2018-09-05"
        }
    ]
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回签章列表 |

获取签章详情

**请求方式：** GET  
**请求地址：**/api/runtime/users/signs/{id}?password={password}

**参数说明：**

| **参数**      | **必须** | **说明**                                      |
|---------------|----------|-----------------------------------------------|
| id | 是       | 签章id                                        |
| password        | 是       | 密码                                    |

**权限说明：**

无。

**返回结果：**

```
{
        "errcode": 0,
        "errmsg": "ok",
        "data": {
            "id": "iUGOhkCPX2QueqG5iUp",
            "name": "123",
            "password": "0d04ee6e708c0136eb0156ef71251544",
            "img": "iUGOhkCPX2QueqG5iUp.jpg",
            "desc": "123",
            "date": "2018-09-05"
        }
    ]
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回签章 |

###  新建签章
-----------------

新建签章

**请求方式：** POST  
**请求地址：**/api/runtime/users/signs

**权限说明：**

无。

**请求包体：**

```
{
	"id": "XdUeahX5pMWYxjzdUVg",
	"name": "1111",
	"password": "2d060d2ee17163955e099c5374da93f4",
	"img": "XdUeahX5pMWYxjzdUVg.jpg",
	"desc": "3333",
	"date": "2018-09-05"
}

```

**参数说明：**

| **参数**  | **必须** | **说明** |
|-----------|----------|----------|
| name      | 是       | 签章名字 |
| id     | 是       | 签章id |
| password | 是       | 签章密码 |
| img | 是       | 签章图片 |
| desc | 是       | 签章备注 |
| date | 是       | 签章时间 |

**返回结果：**

```
{
        "errcode": 0,
        "errmsg": "ok",
        "data": "新建成功"
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 新建成功 |

###  删除签章
-----------------

删除签章

**请求方式：** DELETE  
**请求地址：**/api/runtime/users/signs/{id}

**权限说明：**

无。

**返回结果：**

```
{
        "errcode": 0,
        "errmsg": "ok",
        "data": "删除成功"
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 删除成功 |

###  批量删除签章
-----------------

批量删除签章

**请求方式：** DELETE  
**请求地址：**/api/runtime/users/signs

**权限说明：**

无。

**请求包体：**

```
[
	"id1",
	"id2",
	"id3"
]

```

**参数说明：**

| **参数**  | **必须** | **说明** |
|-----------|----------|----------|
| id      | 是       | id集合 |

**返回结果：**

```
{
        "errcode": 0,
        "errmsg": "ok",
        "data": "删除成功"
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 删除成功 |

## 14.  **部门（Departments）**

### 获取树形结构的部门集合

根据客户端传递的父级部门id参数，服务器返回直属下级部门集合，以树形结构的方式描述数据。

**请求方式：** GET  
**请求地址：**/api/runtime/{applicationId}/departments/selectbox/department?deptId={deptId}&level={level}&belong={belong}

**参数说明：**

| **参数**      | **必须** | **说明**                                      |
|---------------|----------|-----------------------------------------------|
| applicationId | 是       | 软件id                                        |
| deptId        | 是       | 父级部门id                                    |
| level         | 是       | 显示部门级别(-1:所有,0:一级,1:二级,2:三级...) |
| belong        | 是       | 是否只显示当前用户及下属部门(true\|false)     |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "id": "11e7-654a-2b182ffe-9cdb-af6bc8266ed2",
            "name": "产品部",
            "type": 2,
            "code": "",
            "level": "1",
            "parent": "自动化测试用例系统企业域",
            "children": []
        },
        {
            "id": "11e7-5f99-e70d1a49-917f-e799edecb417",
            "name": "测试部",
            "type": 2,
            "code": "001",
            "level": "1",
            "parent": "自动化测试用例系统企业域",
            "children": []
        }
    ]
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回的表单对象，数据结构参考[\#3.3](#获取pdf文件) |

### 获取部门集合或部门下用户集合
----------------------------

根据客户端传递的父级部门id参数，服务器返回该部门下用户集合。当部门id为空时，返回所有部门集合，否则返回该部门下所有用户集合。

**请求方式：** GET  
**请求地址：**/api/runtime/{applicationId}/departments/selectbox/user?deptId={deptId}&pageSize={pageSize}&pageNum={pageNum}

**参数说明：**

| **参数**      | **必须** | **说明**                                 |
|---------------|----------|------------------------------------------|
| applicationId | 是       | 软件id                                   |
| deptId        | 是       | 父级部门id                               |
| pageSize      | 是       | 每页显示数据数（传入0时默认显示5条数据） |
| pageNum       | 是       | 当前页（传入0时默认显示第一页）          |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "id": "11e7-654a-2b182ffe-9cdb-af6bc8266ed2",
            "name": "产品部",
            "type": 2,
            "code": "",
"level": "1",
            "parent": "自动化测试用例系统企业域",
            "children": []
        },
        {  
        }
    ]
}
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "datas": [
            {
                "id": "11e7-5f9a-210f9112-917f-e799edecb417",
                "name": "李玲",
                "type": 1,
                "mobile": "",
                "mobile2": "",
                "email": "jack@teemlink.com",
                "avatar": null,
                "dept": "自动化测试组",
                "deptId": "11e7-5f9a-0020047a-917f-e799edecb417",
                "loginNo": "liling",
                "domainId": "11e7-5f99-cc5d96f1-917f-e799edecb417"
            }
        ],
        "pageCount": 1,
        "rowCount": 2,
        "pageNum": 1,
        "linesPerPage": 5
    }
}

```

**参数说明：**

| **参数**     | **说明**               |
|--------------|------------------------|
| errcode      | 返回码                 |
| errmsg       | 对返回码的文本描述内容 |
| datas        | 部门下用户集合         |
| pageCount    | 总页数                 |
| rowCount     | 总行数                 |
| pageNum      | 当前页                 |
| linesPerPage | 每页显示条数           |

### 搜索功能
--------

根据客户端传递的部门名称，服务器返回查询出的部门集合。

**请求方式：** GET  
**请求地址：**/api/runtime/{applicationId}/departments/selectbox/search?keyword={keyword}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| keywork       | 否       | 部门名称 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "id": "11e7-654a-2b182ffe-9cdb-af6bc8266ed2",
            "name": "产品部",
            "type": 2,
            "code": "",
"level": "1",
            "parent": "自动化测试用例系统企业域",
            "children": []
        },
        {
            "id": "11e7-5f99-e70d1a49-917f-e799edecb417",
            "name": "测试部",
            "type": 2,
            "code": "001",
"level": "1",
            "parent": "自动化测试用例系统企业域",
            "children": []
        }
    ]
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回的表单对象，数据结构参考[\#3.3](#获取pdf文件) |

### 根据父级获取部门集合
--------

根据客户端传递的部门名称，服务器返回查询出的部门集合。

**请求方式：** GET  
**请求地址：**/api/runtime/{applicationId}/departments/selectbox/childs?parentId={parentId}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| parentId       | 否       | 部门id |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "id": "11e7-654a-2b182ffe-9cdb-af6bc8266ed2",
            "name": "产品部",
            "count": 2,
            "child": false
        },
        {
            "id": "11e7-654a-2b182ffe-9cdb-af6bc8266ed2",
            "name": "产品部",
            "count": 2,
            "child": true
        }
    ]
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回部门数据 |

### 部门选择框树形数据结构说明
--------------------------

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "id": "11e7-654a-2b182ffe-9cdb-af6bc8266ed2",
            "name": "产品部",
            "type": 2,
            "code": "",
            "level": "1",
            "parent": "自动化测试用例系统企业域",
            "children": []
        },
        {
            "id": "11e7-5f99-e70d1a49-917f-e799edecb417",
            "name": "测试部",
            "type": 2,
            "code": "001",
            "level": "1",
            "parent": "自动化测试用例系统企业域",
            "children": []
        }
    ]
}

```

**参数说明：**

| **参数** | **说明**                        |
|----------|---------------------------------|
| id       | 部门主键                        |
| name     | 部门名字                        |
| type     | 类型（1用户,2部门,3软件,4角色） |
| code     | 部门代号                        |
| parent   | 父级部门id                      |
| children | 下级部门id                      |
| level    | 部门级别                        |

## 15.  **角色（Roles）**
（暂缺）


## 16.  **个人设置（UserSetups）**

###  个人信息设置

>   服务器返回保存是否的结果。

**请求方式：** POST  
**请求地址：**/api/runtime/usersetups/detail

**请求包体：**

```
{
        "name":"1111",
        "email":"1111",
        "telephone":"1111"
        
    }

```

**参数说明：**

| **参数**  | **必须** | **说明** |
|-----------|----------|----------|
| name      | 是       | 用户名称 |
| email     | 是       | 用户邮箱 |
| telephone | 是       | 用户电话 |

**权限说明：**

无。

**返回结果：**

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回的表单对象，数据结构参考[\#3.3](#获取pdf文件) |

### 密码设置
--------

>   服务器返回保存是否成功的结果。

**请求方式：** POST  
**请求地址：**/api/runtime/usersetups/password

**请求包体：**

```
{
        "oldPassword":"1111",
        "newpassword":"1111",
        "confirmPassword":"1111"
        
    }


```

**参数说明：**

| **参数**        | **必须** | **说明** |
|-----------------|----------|----------|
| oldPassword     | 是       | 原密码   |
| newpassword     | 是       | 新密码   |
| confirmPassword | 是       | 确认密码 |

**权限说明：**

无。

**返回结果：**

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回的表单对象，数据结构参考[\#3.3](#获取pdf文件) |

### 皮肤设置
--------

>   服务器返回保存成功的结果。

**请求方式：** POST  
**请求地址：**/api/runtime/users/skin

**请求包体：**


```
{
    "skin":"1111"
}
```


**参数说明：**

| **参数** | **必须** | **说明** |
|----------|----------|----------|
| skin     | 是       | 皮肤     |

**权限说明：**

无。

**返回结果：**

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回的表单对象，数据结构参考[\#3.3](#获取pdf文件) |

### 系统设置

------

> 服务器返回保存成功的结果。

**请求方式：** GET
**请求地址：**/api/runtime/{userid}/detail

**请求包体：**

```
无
```

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| userid   | 是       | 用户id   |

**权限说明：**

无。

**返回结果：**

{
​    "errcode": 0,
​    "errmsg": "ok",
​    "data": "url"
}

**参数说明：**

| **参数** | **说明**               |
| -------- | ---------------------- |
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 返回的url              |

### 组织切换

------

#### 获取用户所属企业域

>   服务器返回企业域列表的结果。

**请求方式：** GET
**请求地址：**/api/runtime/usersetups/domains

**请求包体：**

```
无
```

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
|          |          |          |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "id": "__4SG7IKUoZuZ4tq9K7hT",
            "sendHost": "smtp.exmail.qq.com",
            "sendAddress": "quan@weioa365.com",
            "sendAccount": "quan@weioa365.com",
            "sendPassword": "VXrZaxVAoDAjZLtf",
            "ccAddress": null,
            "isUseClient": "true",
            "functionDomain": "qq.com",
            "trash": "Junk E-mail",
            "sender": "Sent Items",
            "draft": "Drafts",
            "removed": "removed",
            "fetchServer": "imap.exmail.qq.com",
            "fetchServerPort": "993",
            "fetchProtocol": "imap",
            "fetchssl": null,
            "smtpServer": "smtp.exmail.qq.com",
            "smtpServerPort": "465",
            "smtpAuthenticated": null,
            "smtpssl": null,
            "name": "我的公司",
            "systemName": "",
            "logoUrl": ""
        },
        {
            "id": "__bB4fGzch9L4op1STXR0",
            "sendHost": null,
            "sendAddress": null,
            "sendAccount": null,
            "sendPassword": null,
            "ccAddress": null,
            "isUseClient": null,
            "functionDomain": null,
            "trash": null,
            "sender": null,
            "draft": null,
            "removed": null,
            "fetchServer": null,
            "fetchServerPort": null,
            "fetchProtocol": null,
            "fetchssl": null,
            "smtpServer": null,
            "smtpServerPort": null,
            "smtpAuthenticated": null,
            "smtpssl": null,
            "name": "测试企业域",
            "systemName": "",
            "logoUrl": ""
        }
    ]
}
```

**参数说明：**

| **参数** | **说明**               |
| -------- | ---------------------- |
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 返回企业域列表         |

#### 切换企业域

>   服务器无返回。

**请求方式：** PUT
**请求地址：**/api/runtime/usersetups/domains/switch?domain={domain}

**请求包体：**

```
无
```

**参数说明：**

| **参数** | **必须** | **说明**   |
| -------- | -------- | ---------- |
| domain   | 是       | 企业域名称 |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok"
}
```

**参数说明：**

| **参数** | **说明**               |
| -------- | ---------------------- |
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |

### 代理设置

--------

#### 获取代理列表

>   服务器返回代理列表的结果。

**请求方式：** GET  
**请求地址：**/api/runtime/{applicationId}/usersetups/proxys?flowName={flowName}&pageNo={pageNo}&linesPerPage={linesPerPage}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| flowName | 	否       | 流程名称   |
| pageNo | 		否       |   当前页   |
| linesPerPage | 否   |  每页显示数   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 1,
        "linesPerPage": 10,
        "pageNo": 1,
        "datas": [
            {
                "id": "GBE1IwQSPyGUeklduFq",
                "flowName": "KPI审批流程",
                "flowId": "11e5-73d7-4a37291b-93d0-b7ec49f28add",
                "description": "123",
                "state": "1",
                "agents": "11e4-63ff-5d9df2ad-9f19-57d7b83ae7be",
                "agentsName": "方映春",
                "owner": "11e7-7721-76f875ba-bacd-b744ea587d6a",
                "startProxyTime": 1514217600000,
                "endProxyTime": 1514304000000,
                "proxyMode": 0
            }
        ],
        "pageCount": 1
    }
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回的表单对象，数据结构参考[\#3.3](#获取pdf文件) |

#### 获取代理

>   服务器返回代理的结果。

**请求方式：** GET  
**请求地址：**/api/runtime/{applicationId}/usersetups/proxys/{id}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |
| Id            | 是       | 代理id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 1,
        "linesPerPage": 10,
        "pageNo": 1,
        "datas": 
            {
                "id": "GBE1IwQSPyGUeklduFq",
                "flowName": "KPI审批流程",
                "flowId": "11e5-73d7-4a37291b-93d0-b7ec49f28add",
                "description": "123",
                "state": "1",
                "agents": "11e4-63ff-5d9df2ad-9f19-57d7b83ae7be",
                "agentsName": "方映春",
                "owner": "11e7-7721-76f875ba-bacd-b744ea587d6a",
                "startProxyTime": 1514217600000,
                "endProxyTime": 1514304000000,
                "proxyMode": 0
            }
    }
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回的表单对象，数据结构参考[\#3.3](#获取pdf文件) |

#### 保存代理

>   服务器返回代理列表的结果。

**请求方式：** POST  
**请求地址：**/api/runtime/{applicationId}/usersetups/proxys/save?Id={id}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |

**权限说明：**

无。

**请求包体：**

```
{
                "flowName": "KPI审批流程;啊哈哈哈",
                "flowId": "11e5-73d7-4f28add;11e5-73d7-4a3729128add",
                "description": "123",
                "state": "1",
                "agents": "11e4-63ff-5d9df2ad-9f19-57d7b83ae7be",
                "agentsName": "方映春",
                "owner": "11e7-7721-76f875ba-bacd-b744ea587d6a",
                "startProxyTime": 1514217600000,
                "endProxyTime": 1514304000000,
                "proxyMode": 0
            }

```

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | null |

#### 删除代理

>   服务器返回代理列表的结果。

**请求方式：** DELETE  
**请求地址：**/api/runtime/{applicationId}/usersetups/proxys

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| applicationId | 是       | 软件id   |

**权限说明：**

无。

**请求包体：**

```
    [
        "ID1",
        "ID2",
        "ID3"
    ]

```

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 1,
        "linesPerPage": 10,
        "pageNo": 1,
        "datas": [
            {
                "id": "GBE1IwQSPyGUeklduFq",
                "flowName": "KPI审批流程",
                "flowId": "11e5-73d7-4a37291b-93d0-b7ec49f28add",
                "description": "123",
                "state": "1",
                "agents": "11e4-63ff-5d9df2ad-9f19-57d7b83ae7be",
                "agentsName": "方映春",
                "owner": "11e7-7721-76f875ba-bacd-b744ea587d6a",
                "startProxyTime": 1514217600000,
                "endProxyTime": 1514304000000,
                "proxyMode": 0
            }
        ],
        "pageCount": 1
    }
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回的表单对象，数据结构参考[\#3.3](#获取pdf文件) |

#### 获取流程列表

>   服务器返回流程列表的结果。

**请求方式：** GET  
**请求地址：**/api/runtime/{applicationId}/usersetups/proxys/flows

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| subject       | 否       | 流程主题 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "": "",
        "11e5-73d7-4a37291b-93d0-b7ec49f28add": "KPI审批流程",
        "11e6-539e-f439b6cc-81f5-679a826556ce": "人才推荐",
        "11e6-5302-c8cd341d-a13d-c75d0a89256c": "离职申请",
        "11e6-52dd-ef4a426c-a13d-c75d0a89256c": "调岗申请"
    }
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回的表单对象，数据结构参考[\#3.3](#获取pdf文件) |

### 常用意见设置
--------

#### 获取常用意见列表

>   服务器返回常用意见列表的结果。

**请求方式：** GET  
**请求地址：**/api/runtime/users/{userId}/commonOpinions

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| userId        | 是 | 当前登录用户id |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "id": "79efe485-f704-448f-8c49-bf7bc42a1214",
            "content": "同意"
        },
        {
            "id": "3eedf5d5-9d05-4921-bf61-45351241b15b",
            "content": "批准"
        },
        {
            "id": "6169402c-7915-4393-818c-4cdec6d255dc",
            "content": "OK"
        }
    ]
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 常用意见数据                                      |

#### 添加常用意见

>   服务器返回常用意见的结果。

**请求方式：** POST  
**请求地址：**/api/runtime/users/{userId}/commonOpinions?opinion={opinion}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| userId        | 是 | 当前登录用户id |
| opinion       | 否 | 意见 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": 
        {
            "id": "79efe485-f704-448f-8c49-bf7bc42a1214",
            "content": "同意"
        }
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 常用意见数据                                      |

#### 删除常用意见

>   服务器返回常用意见的结果。

**请求方式：** DELETE  
**请求地址：**/api/runtime/users/{userId}/commonOpinions/{opId}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| userId        | 是 | 当前登录用户id |
| opId          | 是       |  意见id  |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": 
        {
            "id": "79efe485-f704-448f-8c49-bf7bc42a1214",
            "content": "同意"
        }
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 常用意见数据                                      |

#### 修改常用意见

>   服务器返回常用意见的结果。

**请求方式：** PUT  
**请求地址：**/api/runtime/users/{userId}/commonOpinions/{opId}?opinion={opinion}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| userId        | 是 | 当前登录用户id |
| opId          | 是       |  意见id  |
| opinion         | 否       |  意见  |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": 
        {
            "id": "79efe485-f704-448f-8c49-bf7bc42a1214",
            "content": "同意"
        }
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 常用意见数据                                      |

## 17.  **企业域管理（DomainManagers）**

### 获取企业域列表

>   服务器返回企业域列表的结果。

**请求方式：** GET  
**请求地址：**/api/runtime/domains

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|

**权限说明：**

无。

**返回结果：**
```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "pendingFlowList": [
                {
                    "num": 1,
                    "name": "请假申请_串行",
                    "id": "5EWSM5Bm0UOk3cYj4T0"
                },
                {
                    "num": 2,
                    "name": "请假申请",
                    "id": "FPnfiZrQktvBKa5thBd"
                },
                {
                    "num": 1,
                    "name": "简单流程",
                    "id": "UrO2BNuusq43eZj9rW6"
                },
                {
                    "num": 1,
                    "name": "简单流程",
                    "id": "__4D0nLZheR3L616RwbGL"
                },
                {
                    "num": 5,
                    "name": "全部",
                    "id": ""
                }
            ],
            "name": "2.0功能示例",
            "id": "HdPeBqYwJyFyjHkhZu3"
        }
    ]
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回的企业域信息 |


### 根据企业域id获取企业域信息

>   返回企业域信息(系统名称，logo地址)

**请求方式：** GET  
**请求地址：**/api/portal/domain/{domainId}

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| domainId | 是       | 企业域id   |

**权限说明：**

无。

**返回结果：**
```json
{
	"id": "11e1-81e2-37f74759-9124-47aada6b7467",
	"sendHost": null,
	"sendAddress": null,
	"sendAccount": null,
	"sendPassword": null,
	"ccAddress": null,
	"isUseClient": null,
	"functionDomain": null,
	"trash": null,
	"sender": null,
	"draft": null,
	"removed": null,
	"fetchServer": null,
	"fetchServerPort": null,
	"fetchProtocol": null,
	"fetchssl": null,
	"smtpServer": null,
	"smtpServerPort": null,
	"smtpAuthenticated": null,
	"smtpssl": null,
	"name": "我的公司1",
	"systemName": "qqqqq",
	"logoUrl": "/accept.png"
}
```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回的表单对象，数据结构参考[\#3.3](#获取pdf文件) |

## 18.  **软件（Applications）**

###  获取软件列表

>   服务器返回包含表单模板、操作、样式库、数据、权限（数据与权限体现在表单控件的属性）的结果。

**请求方式：** GET  
**请求地址：**/api/runtime/applications

**参数说明：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
    	flowCenter: false, 
    	applications: [{id: "HdPeBqYwJyFyjHkhZu3", name: "2.0功能示例", activated: true},
    	{id: "pm", name: "任务", activated: true},
    	{id: "km", name: "知识文档管理", activated: false}
    	]
    }
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回的表单对象，数据结构参考[\#3.3](#获取pdf文件) |

### 获取系统软件列表
----------------

>   服务器返回包含表单模板、操作、样式库、数据、权限（数据与权限体现在表单控件的属性）的结果。

**请求方式：** GET  
**请求地址：**/api/runtime/applications/sysapplications

**参数说明：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "id": "pm",
            "name": "任务"
        },
        {
            "id": "km",
            "name": "知识文档管理"
        },
        {
            "id": "qm",
            "name": "调查问卷"
        }
    ]
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回的表单对象，数据结构参考[\#3.3](#获取pdf文件) |

## 19.  **消息中心（Messages）**
### 获取通知

>   服务器返回企业动态列表数据。

**请求方式：** GET  
**请求地址：**/api/runtime/messages/notices?pageNo={pageNo}&linesPerPage={linesPerPage}

**参数说明：**

| **参数**     | **必须** | **说明**     |
|--------------|----------|--------------|
| pageNo       | 否       | 当前页       |
| linesPerPage | 否       | 每页显示条数 |

**权限说明：**

无。

**返回结果：**

```
{
        "errcode": 0,
        "errmsg": "ok",
        "data": {
                "datas": [
            {
                "createTime": "2017-11-01T15:22:30",
                "domainid": "11e7-5f99-cc5d96f1-917f-e799edecb417",
                "id": "tgkd9RyPi5FBLY3HBQL",
                "lazyLoad": true,
                "linkParams": {\"_docid\":\"3fwTGoaSiF1Y5A4173f\",\"_formid\":\"11e7-66a6-784b8971-8f1a-bfe936d3ae2a\",\"application\":\"11e7-5f98-d7d66840-917f-e799edecb417\",\"mode\":\"personalMessageMode\"},
                "module": "审批时限设置",
                "read": false,
                "subjectType": 3,
                "summary": "<span class='notice_type' type='3'></span><span class='notice_actor'>李玲</span><span class='notice_flowType'>创建</span><span class='notice_flow'>审批单</span><span class='notice_summary'>设计时分秒-</span>",
                "toUserId": "11e7-5f9a-210f9112-917f-e799edecb417",
                "version": 0
            }
        ],
        "linesPerPage": 30,
        "pageCount": 1,
        "pageNo": 1,
        "rowCount": 10
    }
 }

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回的表单对象，数据结构参考[\#3.3](#获取pdf文件) |

### 标记已读
--------

>   服务器返回企业动态列表数据。

**请求方式：** PUT  
**请求地址：**/api/runtime/messages/notices/{id}/read

**参数说明：**

| **参数** | **必须** | **说明** |
|----------|----------|----------|
| id       | 是       | 通知id   |

**权限说明：**

无。

**返回结果：**

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | null                   |

### 全部标记已读
------------

>   服务器返回企业动态列表数据。

**请求方式：** PUT  
**请求地址：**/api/runtime/messages/notices/read

**参数说明：**

| **参数** | **必须** | **说明** |
|----------|----------|----------|


**权限说明：**

无。

**返回结果：**

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | null                   |

### 删除通知
--------

>   服务器返回企业动态列表数据。

**请求方式：** DELETE  
**请求地址：**/api/runtime/messages/notices/delete

**参数说明：**

| **参数** | **必须** | **说明** |
|----------|----------|----------|


**权限说明：**

无。

**请求包体：**

```
    [
        "ID1",
        "ID2",
        "ID3"
    ]

```

**返回结果：**

**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | null                   |


## 20  **登录模块**

### 注销登录

**请求方式：** POST  
**请求地址：** /api/logout

**参数说明：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "url"
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回的表单对象，数据结构参考[\#3.3](#获取pdf文件) |

### 调试登录-获取企业域列表

**请求方式：** GET  
**请求地址：** /api/debuglogin/getDomainList

**参数说明：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "domainlist"
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回的企业域列表 |

### 调试登录-获取用户列表

**请求方式：** GET  
**请求地址：** /api/debuglogin/getDomainList?domainName={domainName}&username={username}

**参数说明：**
| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| domainName | 是       | 企业域名称   |
| username         | 否       | 用户名   |


**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "userlist"
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回的用户列表 |


### 调试登录-获取登陆页面所需的多语言字段

**请求方式：** GET  
**请求地址：** /api/debuglogin/getMultiLangWordList?language={language}

**参数说明：**
| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| language | 是       | 语言   |


**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "MultiLangWordList"
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回的多语言列表 |

### 调试登录-登陆

**请求方式：** GET  
**请求地址：** /api/debuglogin/loginWithCiphertext2

**参数说明：**
| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| domainName | 是       | 企业域名称   |
| username | 是       | 用户名   |


**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "url"
}

```

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回的url|

### 钉钉免密登录

**请求方式：** GET   

**请求地址：** /api/runtime/dingding/authlogin

**参数说明：**

| **参数** | **必须** | **说明**       |
| -------- | -------- | -------------- |
| code     | 是       | 钉钉免登授权码 |
| domainId | 是       | 企业域id       |
| appId    | 否       | 软件id         |
| formId   | 否       | 表单id         |
| docid    | 否       | 文档id         |

**权限说明：**

无。

**返回结果：**

```
{
    "resultCode": 0,
    "msg": "ok",
    "returnUrl": "url"
}

```

**参数说明：**

| **参数** | **说明**               |
| -------- | ---------------------- |
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 返回的url              |

### 前台解锁

------

前台解锁

**请求方式：** PUT  
**请求地址：**/api/runtime/users/unlock

**参数说明：**

| **参数** | **必须** | **说明**     |
|----------|----------|--------------|

**权限说明：**

无。

**请求包体：**

```
"12312"
```

**返回结果：**

```
{
        "errcode": 0,
        "errmsg": "ok",
        "data": true
}

```

**参数说明：**

| **参数** | **说明**               |
| -------- | ---------------------- |
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 返回是否解锁成信息     |

### 

## 21  **公用**


### 获取序列号

>   服务器返回随机的序列号。

**请求方式：** GET  
**请求地址：** /api/runtime/sequence

**参数说明：**

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "abcdefgshfhx"
}

```

### 下载文件

------

前台解锁

**请求方式：** PUT  
**请求地址：**/api/runtime/file/download?filename={filename}&filepath={filepath}

**参数说明：**

| **参数** | **必须** | **说明**     |
| -------- | -------- | ------------ |
| filename | 是       | 文件名       |
| filepath | 是       | 文件相对路径 |

**权限说明：**

无。

**请求包体：**

```
"12312"
```

**返回结果：**

```
{
        "errcode": 0,
        "errmsg": "ok",
        "data": true
}

```

**参数说明：**

| **参数** | **说明**               |
| -------- | ---------------------- |
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 返回是否解锁成信息     |

### gps定位纠偏

------

gps定位纠偏

**请求方式：** GET  
**请求地址：**/api/runtime/gps/convert?x={x}&y={y}

**参数说明：**

| **参数** | **必须** | **说明**     |
| -------- | -------- | ------------ |
| x | 是       | 经度       |
| y | 是       | 维度 |

**权限说明：**

无。

**请求包体：**


**返回结果：**

```
{
        "errcode": 0,
        "errmsg": "ok",
        "data": {
            "x":"123123123.123",
            "y":"2221111.32"
        }
}

```

**参数说明：**

| **参数** | **说明**               |
| -------- | ---------------------- |
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 返回是否解锁成信息     |

### 同步表数据

------

同步表数据

**请求方式：** POST  
**请求地址：**/api/runtime/sync/data

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |

**权限说明：**

无。

**请求包体：**

```json
{
    "action": "create",
    "applicationId": "sOZu9kthmxyP8qQfq0e",
    "dataObject": {
        "columnValues": [
            {
                "name": "id",
                "type": "text",
                "value": "Z42xU8LmniRouZ93E7s"
            },
            {
                "name": "name",
                "type": "text",
                "value": "总部"
            },
            {
                "name": "domain_id",
                "type": "text",
                "value": "3CffNlgt9B9StIjIUPB"
            },
            {
                "name": "levels",
                "type": "integer",
                "value": "0"
            },
            {
                "name": "indexcode",
                "type": "text",
                "value": "5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s"
            },
            {
                "name": "code",
                "type": "text",
                "value": "1"
            },
            {
                "name": "sortid",
                "type": "text",
                "value": ""
            },
            {
                "name": "valid",
                "type": "integer",
                "value": "1"
            },
            {
                "name": "orderbyno",
                "type": "integer",
                "value": "0"
            },
            {
                "name": "weixin_dept_id",
                "type": "text",
                "value": "1"
            },
            {
                "name": "lanxin_dept_id",
                "type": "text",
                "value": ""
            },
            {
                "name": "field1",
                "type": "text",
                "value": ""
            },
            {
                "name": "field2",
                "type": "text",
                "value": ""
            },
            {
                "name": "field3",
                "type": "text",
                "value": ""
            },
            {
                "name": "field4",
                "type": "text",
                "value": ""
            },
            {
                "name": "field5",
                "type": "text",
                "value": ""
            },
            {
                "name": "field6",
                "type": "text",
                "value": ""
            },
            {
                "name": "field7",
                "type": "text",
                "value": ""
            },
            {
                "name": "field8",
                "type": "text",
                "value": ""
            },
            {
                "name": "field9",
                "type": "text",
                "value": ""
            },
            {
                "name": "field10",
                "type": "text",
                "value": ""
            },
            {
                "name": "field11",
                "type": "text",
                "value": ""
            },
            {
                "name": "field12",
                "type": "text",
                "value": ""
            },
            {
                "name": "field13",
                "type": "text",
                "value": ""
            },
            {
                "name": "field14",
                "type": "text",
                "value": ""
            },
            {
                "name": "field15",
                "type": "text",
                "value": ""
            },
            {
                "name": "field16",
                "type": "text",
                "value": ""
            },
            {
                "name": "field17",
                "type": "text",
                "value": ""
            },
            {
                "name": "field18",
                "type": "text",
                "value": ""
            },
            {
                "name": "field19",
                "type": "text",
                "value": ""
            },
            {
                "name": "field20",
                "type": "text",
                "value": ""
            },
            {
                "name": "dingding_dept_id",
                "type": "text",
                "value": ""
            }
        ],
        "id": "Z42xU8LmniRouZ93E7s",
        "tableName": "t_department"
    },
    "dataSourceName": "测试连接"
}
```

**参数说明：**

| **参数**                | 必须 | **说明**                                                     |
| ----------------------- | ---- | ------------------------------------------------------------ |
| action                  | 是   | 动作类型（create新建，update更新，save新建或保存，delete删除） |
| applicationId           | 是   | 软件id                                                       |
| dataSourceName          | 是   | 数据源名称                                                   |
| dataObject              | 是   | 数据对象                                                     |
| dataObject.id           | 是   | 数据id                                                       |
| dataObject.tableName    | 是   | 表名                                                         |
| dataObject.columnValues | 是   | 字段对象                                                     |
| columnValues[0].name    | 是   | 字段名称                                                     |
| columnValues[0].type    | 是   | 字段类型                                                     |
| columnValues[0].value   | 是   | 字段值                                                       |

**返回结果：**

```
{
    "errcode": 0,
	"errmsg": "ok"
}
```

**参数说明：**

| **参数** | **说明**               |
| -------- | ---------------------- |
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |

### 同步文件 

------

同步表数据

**请求方式：** POST  
**请求地址：**/api/runtime/sync/file

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |

**权限说明：**

无。

**请求包体：**

```json
{
    "downloadUrl": "http://localhost:8083/obpm/uploads/item/2021/a29bbf24-fb23-4413-b8eb-38512a22d666.docx?accessToken=eyJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJhdXRoMCIsImV4cCI6MTYyMDcxMjE2NSwidXNlcm5hbWUiOiJfXzdNM1RyWXdtYTJqYzFaY0ZySHEifQ.AnSAvhVk3Y4KZ1jpd0VCSnqW4gyVms5QS6L0oHimHgA",
    "pathOnTargetServer": "D:/obpm-demo/uploads/item/2021/a29bbf24-fb23-4413-b8eb-38512a22d666.docx"
}
```

**参数说明：**

| **参数**           | 必须 | **说明**         |
| ------------------ | ---- | ---------------- |
| downloadUrl        | 是   | 文件下载地址     |
| pathOnTargetServer | 是   | 文件目标存储地址 |

**返回结果：**

```
{
    "errcode": 0,
	"errmsg": "ok"
}
```

**参数说明：**

| **参数** | **说明**               |
| -------- | ---------------------- |
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |

### 获取前台用户accessToken

------

同步表数据

**请求方式：** GET  
**请求地址：**/api/runtime/secrets/{secret}/accessToken?loginNo={loginNo}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| secret   | 是       | 密钥     |
| loginNo  | 是       | 用户账号 |

**权限说明：**

无。

**请求包体：**

无。

**参数说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
	"errmsg": "ok",
	"data": "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJhdXRoMCIsImV4cCI6MTYyNjg2Mzk4OCwidXNlcm5hbWUiOiJEUzZaMWwyT0NPVU9LOWxUNzR6In0.4RpAY67dFKVYJ4oLFO7TsTrsMfeAGqijFDQz0DjelWY"
}
```

**参数说明：**

| **参数** | **说明**               |
| -------- | ---------------------- |
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 用户token              |

## 22  **同步软件的数据表单**

### 同步软件的数据表单

**请求方式：** POST  
**请求地址：** /api/runtime/synchronization/forms?applicationId={applicationId}

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |

**权限说明：**

无。

**返回结果：**

```
{"errcode":0,"errmsg":"ok"}
```

**参数说明：**

| **参数** | **说明**               |
| -------- | ---------------------- |
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 返回序列号             |

## 23. **统计图模块**

### 获取统计图的数据内容

**请求方式：** POST
**请求地址：**/api/runtime/chart/{id}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| id       | 是       | 统计图id |
| content  | 否       | 请求包体 |

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"result": "option",
		"view": "view",
		"appId": "HdPeBqYwJyFyjHkhZu3"
	}
}
```

**参数说明：**

| **参数** | **说明**               |
| -------- | ---------------------- |
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 返回数据包             |

### 获取统计图的查询表单模板

> 服务器返回报表的查询表单模板的结果。

**请求方式：** GET  
**请求地址：**/api/runtime/chart/{id}/searchformtemplate/{applicationId}

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| id            | 是       | 统计图id |
| applicationId | 是       | 软件id   |

**权限说明：**

无。

**返回结果：**

```
{  
  "errcode" : 0,  
  "errmsg" : "ok",
  "data" : {
    " fields": [],
    " document": {},
    " template": ".."
    }
}

```

**参数说明：**

| **参数** | **说明**               |
| -------- | ---------------------- |
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 查询表单数据           |

## 24. **评论模块**

### 获取评论统计

**请求方式：** GET
**请求地址：**/api/runtime/{applicationId}/flags/{flag}/comments/count

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| flag          | 是       | 评论标识 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "commentNum": 3,
        "likeNum": 0,
        "id": "cOBQIpCvBqUt55LC7Fi"
    }
}
```

**参数说明：**

| **参数**        | **说明**               |
| --------------- | ---------------------- |
| errcode         | 返回码                 |
| errmsg          | 对返回码的文本描述内容 |
| data            | 返回数据包             |
| data.id         | 主键                   |
| data.commentNum | 评论条数               |
| data.likeNum    | 点赞次数               |

### 获取评论列表

**请求方式：** GET
**请求地址：**/api/runtime/{applicationId}/flags/{flag}/comments

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| flag          | 是       | 评论标识 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "id": "i5amKH9m4leqrXMu5RP",
            "comment": "我是评论呢",
            "flag": "4KSca72zzVtijBmNN0",
            "userId": "Fyerrqyr53YShQ8KRya",
            "userName": "超级管理员",
            "likeNum": 3,
            "unlikeNum": 1,
            "createDate": 1628611200000,
            "parentId": "",
            "avatar":""
        }
    ]
}
```

**参数说明：**

| **参数**           | **说明**               |
| ------------------ | ---------------------- |
| errcode            | 返回码                 |
| errmsg             | 对返回码的文本描述内容 |
| data               | 返回数据包             |
| data[0].id         | 主键                   |
| data[0].comment    | 评论内容               |
| data[0].flag       | 评论标识               |
| data[0].userId     | 用户id                 |
| data[0].userName   | 用户名称               |
| data[0].likeNum    | 点赞次数               |
| data[0].unlikeNum  | 觉得不行次数           |
| data[0].createDate | 创建时间               |
| data[0].parentId   | 父级id                 |
| data[0].avatar     | 头像                   |

### 获取回复列表

**请求方式：** GET
**请求地址：**/api/runtime/{applicationId}/comments/{commentId}/answers

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| commentId     | 是       | 评论id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "id": "i5amKH9m4leqrXMu5RP",
            "comment": "我是评论呢",
            "flag": "4KSca72zzVtijBmNN0r",
            "userId": "Fyerrqyr53YShQ8KRya",
            "userName": "超级管理员",
            "likeNum": 3,
            "unlikeNum": 1,
            "createDate": 1628611200000,
            "parentId": "",
            "avatar": ""
        }
    ]
}
```

**参数说明：**

| **参数**           | **说明**               |
| ------------------ | ---------------------- |
| errcode            | 返回码                 |
| errmsg             | 对返回码的文本描述内容 |
| data               | 返回数据包             |
| data[0].id         | 主键                   |
| data[0].comment    | 评论内容               |
| data[0].flag       | 评论标识               |
| data[0].userId     | 用户id                 |
| data[0].userName   | 用户名称               |
| data[0].likeNum    | 点赞次数               |
| data[0].unlikeNum  | 觉得不行次数           |
| data[0].createDate | 创建时间               |
| data[0].parentId   | 父级id                 |
| data[0].avatar     | 头像                   |

### 新建评论（回复）

**请求方式：** POST
**请求地址：**/api/runtime/{applicationId}/flags/{flag}/comments

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| flag          | 是       | 评论标识 |

**权限说明：**

无。

**请求包体：**

```
{
    "comment":"我是回复呢",
    "parentId":"i5amKH9m4leqrXMu5RP"
}
```

**参数说明：**

| **参数** | **说明**                     |
| -------- | ---------------------------- |
| comment  | 评论内容                     |
| parentId | 回复的评论id(创建评论时为空) |

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "i5amKH9m4leqrXMu5RP",
        "comment": "我是评论呢",
        "flag": "4KSca72zzVtijBmNN0r",
        "userId": "Fyerrqyr53YShQ8KRya",
        "userName": "超级管理员",
        "likeNum": 3,
        "unlikeNum": 1,
        "createDate": 1628611200000,
        "parentId": "i5amKH9m4leqrXMu5RP"
    }
}
```

**参数说明：**

| **参数**        | **说明**               |
| --------------- | ---------------------- |
| errcode         | 返回码                 |
| errmsg          | 对返回码的文本描述内容 |
| data            | 返回数据包             |
| data.id         | 主键                   |
| data.comment    | 评论内容               |
| data.flag       | 评论标识               |
| data.userId     | 用户id                 |
| data.userName   | 用户名称               |
| data.likeNum    | 点赞次数               |
| data.unlikeNum  | 觉得不行次数           |
| data.createDate | 创建时间               |
| data.parentId   | 父级id                 |

### 点赞

**请求方式：** PUT
**请求地址：**/api/runtime/{applicationId}/comments/{commentId}/like

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| commentId     | 是       | 评论id   |

**权限说明：**

无。

**请求包体：**

无。

**参数说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": 1
}
```

**参数说明：**

| **参数** | **说明**               |
| -------- | ---------------------- |
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 返回点赞次数           |

### 觉得不行

**请求方式：** PUT
**请求地址：**/api/runtime/{applicationId}/comments/{commentId}/unlike

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationId | 是       | 软件id   |
| commentId     | 是       | 评论id   |

**权限说明：**

无。

**请求包体：**

无。

**参数说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": 1
}
```

**参数说明：**

| **参数** | **说明**               |
| -------- | ---------------------- |
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 返回觉得不行次数       |

## 25. **debug调试**（macro）

### 是否开启调式模式

**请求方式：** GET  

**请求地址：**/api/runtime/macro/isdebug

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
|          |          |          |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": true
}
```

**参数说明：**

| **参数** | **说明**                   |
| -------- | -------------------------- |
| errcode  | 返回码                     |
| errmsg   | 对返回码的文本描述内容     |
| data     | 返回是否开启（true/false） |

### 设置是否开启调式模式

**请求方式：** PUT  

**请求地址：**/api/runtime/macro/debug?isDebug={isDebug}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| isDebug  | 是       | 是否开启 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": true
}
```

**参数说明：**

| **参数** | **说明**                   |
| -------- | -------------------------- |
| errcode  | 返回码                     |
| errmsg   | 对返回码的文本描述内容     |
| data     | 返回是否开启（true/false） |

### 刷新操作

**请求方式：** PUT  

**请求地址：**/api/runtime/macro/refresh

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
|          |          |          |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": true
}
```

**参数说明：**

| **参数** | **说明**                   |
| -------- | -------------------------- |
| errcode  | 返回码                     |
| errmsg   | 对返回码的文本描述内容     |
| data     | 返回是否开启（true/false） |

### 执行操作

```
1.go 进入下一个断点
2.Step Over 单步跳过
3.Step Into 单步进入
4.Step Out 单步退出
```

**请求方式：** PUT  

**请求地址：**/api/runtime/macro/conduct?action={action}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| action   | 是       | 动作类型 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": true
}
```

**参数说明：**

| **参数** | **说明**                   |
| -------- | -------------------------- |
| errcode  | 返回码                     |
| errmsg   | 对返回码的文本描述内容     |
| data     | 返回是否开启（true/false） |

### 运行脚本

**请求方式：** PUT  

**请求地址：**/api/runtime/macro/evalexpr

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
|          |          |          |

**权限说明：**

无。

**请求包体：**

```
"asdasfdfhfhjyhjkhuiuurgdf"

```

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "sssss"
}
```

**参数说明：**

| **参数** | **说明**               |
| -------- | ---------------------- |
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 返回执行后的结果       |

## 26. **全局错误码参考**

==============

**状态码说明：**

| **状态码** | **说明** |
|------------|----------|
| \-1        | 处理失败 |
| 0          | 处理成功 |
| 40001      |          |
| 40002      |          |
| 40003      |          |
| 40004      |          |
| 40005      |          |

**错误信息数据结构（errors）：**

```
        {  
          "errcode" : 40035,  
          "errmsg" : "Validation Failed",  
          "errors" : [
            {  
              "errcode" : 40035,  
              "field" : "name",  
              "errmsg" : "name cannot have fancy characters"  
            },  
            {  
               "errcode" : 40035,  
               "field" : "age",  
               "errmsg" : "age cannot be blank"  
            }  
          ]  
        }

```

**错误信息参数说明：**

| **参数** | **说明**                     |
|----------|------------------------------|
| errcode  | 返回码                       |
| errmsg   | 状态码对应的信息文本         |
| field    | 字段名称（错误对应的作用域） |

